<?php
	$this->load->library('fpdf');
	
	$GLOBALS['dataArray'] = array(
        'Empresa' => $configs['NombreEmpresa'],
        'Direccion' => $configs['DireccionEmpresa'],
        'Logo' => base_url($configs['LogoEmpresa']),
		'FechaDesde' => $fechadesde,
        'FechaHasta' => $fechahasta
    );
	
	class PDF extends FPDF{
    
        function Header(){
            global $dataArray;
			$fechadesde = new DateTime($dataArray['FechaDesde']);
			$fechahasta = new DateTime($dataArray['FechaHasta']);
			
            $this->Image($dataArray['Logo'],250,5,25);
            $this->SetFont('Arial','B',12);
            $this->SetY(6);
            $this->Cell(0,8,utf8_decode('Reporte de Ventas'),0,1,'C');
            $this->SetFont('Arial','B',9);
            $this->SetY(12);
            $this->Cell(0,8,strtoupper(utf8_decode($dataArray['Empresa'])),0,1,'C');
            $this->SetY(17);
            $this->Cell(0,8,strtoupper(utf8_decode($dataArray['Direccion'])),0,1,'C');
            $this->Ln(3);
			
			$this->SetFont('Arial','',9);
            $this->Cell(20,8,'Periodo',0,0,'L');
			$this->SetFont('Arial','B',9);
            $this->Cell(50,8,$fechadesde->format('d-m-Y').' - '.$fechahasta->format('d-m-Y'),0,1,'L');
			$this->Ln(3);
        }
        
        function Footer(){
            $this->SetY(-25);
            $this->SetFont('Arial','I',7);
            $this->Cell(200,6,utf8_decode('Pagina '.$this->PageNo().'/{nb}'),0,0,'L');
            $this->Cell(60,6,utf8_decode(gmdate('d-m-Y H:i:s', strtotime('- 6 hours'))),0,1,'R');
            $this->Cell(60,6,utf8_decode('Miracle v1.5 - Todos los Derechos Reservados 2012 - '.date('Y').' - Xypnos Soluciones Tecnologicas'),0,1,'L');
        }
    }
	
	$pdf = new PDF();
    $pdf->AliasNbPages(); 
    $pdf->setTitle('Reporte de Ventas');
    $pdf->setAuthor('Miracle v1.5 - Xypnos');
    $pdf->AddPage('L','Letter');
	
	/*Header Tabla*/
	$pdf->Cell(20,8,'Ref',1,0,'C');
	$pdf->Cell(25,8,'Fecha',1,0,'C');
	$pdf->Cell(45,8,'Vendedor',1,0,'C');
	$pdf->Cell(45,8,'Cajero',1,0,'C');
	$pdf->Cell(35,8,'Documento',1,0,'C');
	$pdf->Cell(30,8,'Subt',1,0,'C');
	$pdf->Cell(30,8,'Desc',1,0,'C');
	$pdf->Cell(30,8,'Total',1,1,'C');
    $pdf->SetFont('Arial','',9);
    $pdf->SetFillColor(255, 255, 126);
	
	  /*Cuerpo del Documento*/
	$total = 0;
	$totaldev = 0;
	if(isset($transacciones) && count($transacciones) > 0){
		foreach($transacciones as $transaccion):
			$Y = $pdf->GetY();
			if($transaccion->tipo==="venta"){
                if($transaccion->estado==1){
                    $pdf->Cell(20,8,"V-".$transaccion->referencia,1,0,'L');
                    $total+=$transaccion->grabado+$transaccion->nosujeto+$transaccion->exento+$transaccion->impuestos-$transaccion->descuento;
                }else{
                    $pdf->Cell(20,8,"V-".$transaccion->referencia."*",1,0,'L');
                    $totaldev+=$transaccion->grabado+$transaccion->nosujeto+$transaccion->exento+$transaccion->impuestos-$transaccion->descuento;
                }
			}else{
				$pdf->Cell(20,8,"D-".$transaccion->referencia,1,0,'L');
				$total-=$transaccion->grabado+$transaccion->nosujeto+$transaccion->exento+$transaccion->impuestos-$transaccion->descuento;
			}
			$pdf->MultiCell(25,4,$transaccion->fecha,1,'C');
			$pdf->SetXY($pdf->GetX()+45,$pdf->GetY()-8);
			if($pdf->GetStringWidth($transaccion->vendedor) > 45){
				$pdf->MultiCell(45,4,$transaccion->vendedor,1,'L');
				$pdf->SetXY($pdf->GetX()+95,$pdf->GetY()-8);				
			}else{
				$pdf->Cell(45,8,$transaccion->vendedor,1,0,'L');
			}
			if($pdf->GetStringWidth($transaccion->cajero) > 45){
				$pdf->MultiCell(45,4,$transaccion->cajero,1,'L');
				$pdf->SetXY($pdf->GetX()+145,$pdf->GetY()-8);				
			}else{
				$pdf->Cell(45,8,$transaccion->cajero,1,0,'L');
			}
			$doctype=$transaccion->documento;
			$doc = $transaccion->documento=$documentos[$transaccion->documento]["shortName"]." No ".$transaccion->numero;
			if($pdf->GetStringWidth($doc) > 35){
				$pdf->MultiCell(35,4,$doc,1,'L');
				$pdf->SetXY($pdf->GetX()+175,$pdf->GetY()-8);				
			}else{
				$pdf->Cell(35,8,$doc,1,0,'L');
			}
			$pdf->Cell(5,8,"$","TLB",0,'C');
			$pdf->Cell(25,8,number_format($transaccion->grabado+$transaccion->impuestos,2),"TRB",0,'R');
			$pdf->Cell(5,8,"$","TLB",0,'C');
			$pdf->Cell(25,8,number_format($transaccion->descuento,2),"TRB",0,'R');
            if($transaccion->estado==1){
                $pdf->Cell(5,8,"$","TLB",0,'C');
                $pdf->Cell(25,8,number_format($transaccion->total+$transaccion->nosujeto+$transaccion->exento+$transaccion->impuestos,2),"TRB",1,'R');
            }else{
                $pdf->Cell(5,8,"$","TLB",0,'C',true);
                $pdf->Cell(25,8,number_format($transaccion->total+$transaccion->nosujeto+$transaccion->exento+$transaccion->impuestos,2),"TRB",1,'R',true);
            }
			
			if($includeProducts && is_array($transaccion->productos)){
				/*Header*/
				$pdf->SetFont('Arial','B',9);
				$pdf->Cell(50,8,utf8_decode(ucwords("")),0,0,'L');
				$pdf->Cell(30,8,utf8_decode(ucwords("SKU")),0,0,'L');
				$pdf->Cell(30,8,utf8_decode(ucwords("Cantidad")),0,0,'L');
				$pdf->Cell(30,8,utf8_decode(ucwords("Costo")),0,0,'L');
				$pdf->Cell(90,8,utf8_decode(ucwords("Producto")),0,0,'L');
				$pdf->Cell(30,8,utf8_decode(ucwords("Total")),0,1,'L');
				$pdf->SetFont('Arial','',8);
				foreach($transaccion->productos as $producto){
					$pdf->Cell(50,8,utf8_decode(ucwords("")),0,0,'L');
					$pdf->Cell(30,8,utf8_decode(ucwords($producto->sku)),0,0,'L');
					$pdf->Cell(30,8,number_format($producto->cant,2),0,0,'L');
					if($doctype==2){
						$pdf->Cell(30,8,number_format($producto->costo+(($producto->costo)*0.13),2),0,0,'L');
					}else{
						$pdf->Cell(30,8,number_format($producto->costo,2),0,0,'L');
					}
					if($pdf->GetStringWidth($producto->desc) > 90){
						if($pdf->GetStringWidth($producto->desc) > 180){
							$fontSize = 8;
							//$pdf->SetFontSize($fontSize -= 0.5);
							$pdf->MultiCell(90,4,utf8_decode(strtoupper(substr($producto->desc,0,50)."...")),0,'L');
							$pdf->SetXY($pdf->GetX()+230,$pdf->GetY()-8);
						}else{
							$pdf->MultiCell(90,4,utf8_decode(strtoupper($producto->desc)),0,'L');
							$pdf->SetXY($pdf->GetX()+230,$pdf->GetY()-8);
						}				
					}else{
					   $pdf->Cell(90,8,utf8_decode(strtoupper($producto->desc)),0,0,'L');
					}
					//$pdf->SetFontSize(11);
					
					//$pdf->Cell(30,8,utf8_decode(ucwords($producto->desc)),0,0,'L');
					if($doctype==2){
						$pdf->Cell(30,8,number_format(($producto->cant * $producto->costo)+(($producto->cant * $producto->costo)*0.13),2),0,1,'L');						
					}else{
						$pdf->Cell(30,8,number_format($producto->cant * $producto->costo,2),0,1,'L');		
					}
				}				
			}
		endforeach;
		$pdf->SetFont('Arial','B',9);
		$pdf->Cell(200,8,"",0,0,'R');
		$pdf->Cell(30,8,"Subtotal",1,0,'L');
		$pdf->Cell(5,8,"$","TLB",0,'C');
        $pdf->Cell(25,8,number_format($total+$totaldev,2),"TRB",1,'R');
        $pdf->SetFont('Arial','B',9);
		$pdf->Cell(200,8,"",0,0,'R');
		$pdf->Cell(30,8,"Devoluciones",1,0,'L');
		$pdf->Cell(5,8,"$","TLB",0,'C');
        $pdf->Cell(25,8,"(".number_format($totaldev,2).")","TRB",1,'R');
        $pdf->SetFont('Arial','B',9);
		$pdf->Cell(200,8,"",0,0,'R');
		$pdf->Cell(30,8,"Total",1,0,'L');
		$pdf->Cell(5,8,"$","TLB",0,'C');
		$pdf->Cell(25,8,number_format($total,2),"TRB",1,'R');
	}
	
	/*Exportamos el PDF*/
    $pdf->Output('Reporte de Ventas.pdf','I');
?>