<div class="row">
	<div class="col-lg-6">
		<div class="ibox float-e-margins">
			<div class="ibox-title">
				<h5>Compras</h5>
			</div>
			<div class="ibox-content">
				<div class="row">
					<div class="col-lg-12">
						<div class="row">
							<div class="col-sm-3">
								<label>Tipo</label>
								<select class="form-control" id="reportes-compras-tipo">
									<option value='mensual'>Mensual</option>
									<option value='diario'>Diario</option>
								</select>
							</div>
							<div class="col-sm-2">
								<label>Desde</label>
								<input type="text" class="form-control" id="reportes-compras-desde-month" readonly>
								<input type="text" class="form-control" id="reportes-compras-desde-days" readonly style="display:none;">
							</div>
							<div class="col-sm-2">
								<label>Hasta</label>
								<input type="text" class="form-control" id="reportes-compras-hasta-month" readonly>
								<input type="text" class="form-control" id="reportes-compras-hasta-days" readonly style="display:none;">
							</div>
							<div class="col-sm-2">
								<label>Con Valores</label>
								<input type="checkbox" class="i-checks" id="reportes-compras-mostrar">
							</div>
							<div class="col-sm-3">
								<button class="btn btn-info m-t-md" id="construirGraficoCompras">Construir</button>
							</div>
						</div>
					</div>
				</div>
				<div class="hr-line-dashed"></div>
				<div class="compras-ajax-content" style="height:375px;">
				</div>
			</div>
		</div>
	</div>
	<!---->
	<div class="col-lg-6">
		<div class="ibox float-e-margins">
			<div class="ibox-title">
				<h5>Devoluciones</h5>
			</div>
			<div class="ibox-content">
				<div class="row">
					<div class="col-lg-12">
						<div class="row">
							<div class="col-sm-3">
								<label>Tipo</label>
								<select class="form-control" id="reportes-devoluciones-tipo">
									<option value='mensual'>Mensual</option>
									<option value='diario'>Diario</option>
								</select>
							</div>
							<div class="col-sm-2">
								<label>Desde</label>
								<input type="text" class="form-control" id="reportes-devoluciones-desde-month" readonly>
								<input type="text" class="form-control" id="reportes-devoluciones-desde-days" readonly style="display:none;">
							</div>
							<div class="col-sm-2">
								<label>Hasta</label>
								<input type="text" class="form-control" id="reportes-devoluciones-hasta-month" readonly>
								<input type="text" class="form-control" id="reportes-devoluciones-hasta-days" readonly style="display:none;">
							</div>
							<div class="col-sm-2">
								<label>Con Valores</label>
								<input type="checkbox" class="i-checks" id="reportes-devoluciones-mostrar">
							</div>
							<div class="col-sm-3">
								<button class="btn btn-info m-t-md" id="construirGraficoDevoluciones">Construir</button>
							</div>
						</div>
					</div>
				</div>
				<div class="hr-line-dashed"></div>
				<div class="devoluciones-ajax-content" style="height:375px;">
				</div>
			</div>
		</div>
	</div>
</div>
<div class="row">
	<div class="col-lg-6">
		<div class="ibox float-e-margins">
			<div class="ibox-title">
				<h5>Compras por proveedor</h5>
			</div>
			<div class="ibox-content">
				<div class="row"><!--Ventas x lineas-->
					<div class="col-lg-12">
						<div class="row">
							<div class="col-sm-2">
								<label>Desde</label>
								<input type="text" class="form-control" id="reportes-proveedor-desde-days" readonly>
							</div>
							<div class="col-sm-2">
								<label>Hasta</label>
								<input type="text" class="form-control" id="reportes-proveedor-hasta-days" readonly>
							</div>
							<div class="col-sm-3">
								<label>Tipo de Grafico</label>
								<select class="form-control" id="reportes-proveedor-tipo">
									<option value='pastel'>Pastel</option>
									<option value='barras'>Barras</option>
								</select>
							</div>
							<div class="col-sm-2">
								<label>Con Valores</label>
								<input type="checkbox" class="i-checks" id="reportes-proveedor-mostrar" checked>
							</div>
							<div class="col-sm-3">
								<button class="btn btn-info m-t-md" id="construirGraficoProveedor">Construir</button>
							</div>
						</div>
					</div>
				</div>
				<div class="hr-line-dashed"></div>
				<div class="proveedor-ajax-content" style="height:375px;">
				</div>
			</div>
		</div>
	</div>
	<!---->
</div>
<script>
$(document).ready(function(){
	$('.i-checks').iCheck({
		checkboxClass: 'icheckbox_square-green',
		radioClass: 'iradio_square-green',
	});
	
	/*Compras*/
	$("#construirGraficoCompras").on("click",function(){
		var valid = true;
		var fechadesde = "";
		var fechahasta = "";
		var valores = false;
		
		if($("#reportes-compras-mostrar").is(":checked")){
			valores = true;
		}
		
		if($('#reportes-compras-tipo').val()=='mensual'){
			if($('#reportes-compras-desde-month').val() == ""){
				$('#reportes-compras-desde-month').focus();
				valid = false;
			}else if($('#reportes-compras-hasta-month').val() == ""){
				$('#reportes-compras-hasta-month').focus();
				valid = false;
			}else{
				fechadesde = $('#reportes-compras-desde-month').val();
				fechahasta = $('#reportes-compras-hasta-month').val();
			}
		}else{
			if($('#reportes-compras-desde-days').val() == ""){
				$('#reportes-compras-desde-days').focus();
				valid = false;
			}else if($('#reportes-compras-hasta-days').val() == ""){
				$('#reportes-compras-hasta-days').focus();
				valid = false;
			}else{
				fechadesde = $('#reportes-compras-desde-days').val();
				fechahasta = $('#reportes-compras-hasta-days').val();
			}
		}
		if(valid){
			$.get('<?php echo base_url();?>reportes/grafico_compras?fechadesde='+fechadesde+'&fechahasta='+fechahasta+'&tipo='+$('#reportes-compras-tipo').val()+'&valores='+valores)
			.done(function(data){                
				$('.compras-ajax-content').html(data);
			});
		}else{
			toastr.options = {
			  "closeButton": true,
			  "progressBar": true,
			  "positionClass": "toast-top-right"
			}
			toastr.error('Hace falta informacion necesaria para enviar el formulario, favor verifique');
		}		
	});
	
	$('#reportes-compras-tipo').change(function(){
		if($(this).val()=='mensual'){
			$('#reportes-compras-desde-month, #reportes-compras-hasta-month').val('');
			$('#reportes-compras-desde-days, #reportes-compras-hasta-days').val('');
			
			$('#reportes-compras-desde-month, #reportes-compras-hasta-month').show();
			$('#reportes-compras-desde-days, #reportes-compras-hasta-days').hide();
		}else{
			$('#reportes-compras-desde-month, #reportes-compras-hasta-month').val('');
			$('#reportes-compras-desde-days, #reportes-compras-hasta-days').val('');
			
			$('#reportes-compras-desde-month, #reportes-compras-hasta-month').hide();
			$('#reportes-compras-desde-days, #reportes-compras-hasta-days').show();
		}
	});
	$('#reportes-compras-desde-month, #reportes-compras-hasta-month').datepicker({
		language:'es',
		autoclose:true,
		format: "yyyy-mm", 
		startView: "months", 
		minViewMode: "months" 
	});
	var inicio_compras_diario = $('#reportes-compras-desde-days').datepicker({
		language:'es',
		format:'yyyy-mm-dd',
		autoclose:true
	}).on('changeDate', function (ev) {
			var newDate = new Date(ev.date);
			newDate.setDate(newDate.getDate());
			fin_compra_diario.datepicker("update", newDate);
			$('#reportes-compras-hasta-days')[0].focus();
	});
	var fin_compra_diario = $('#reportes-compras-hasta-days').datepicker({
		language:'es',
		format:'yyyy-mm-dd',
		beforeShowDay: function (date) {
			if (!inicio_compras_diario.datepicker("getDate").valueOf()) {
				return date.valueOf() >= new Date().valueOf();
			} else {
				return date.valueOf() > inicio_compras_diario.datepicker("getDate").valueOf()-1;
			}
		},
		autoclose: true

	}).on('changeDate', function (ev) {}); 
	
	/*Devoluciones*/
	$("#construirGraficoDevoluciones").on("click",function(){
		var valid = true;
		var fechadesde = "";
		var fechahasta = "";
		var valores = false;
		
		if($("#reportes-devoluciones-mostrar").is(":checked")){
			valores = true;
		}
		
		if($('#reportes-devoluciones-tipo').val()=='mensual'){
			if($('#reportes-devoluciones-desde-month').val() == ""){
				$('#reportes-devoluciones-desde-month').focus();
				valid = false;
			}else if($('#reportes-devoluciones-hasta-month').val() == ""){
				$('#reportes-devoluciones-hasta-month').focus();
				valid = false;
			}else{
				fechadesde = $('#reportes-devoluciones-desde-month').val();
				fechahasta = $('#reportes-devoluciones-hasta-month').val();
			}
		}else{
			if($('#reportes-devoluciones-desde-days').val() == ""){
				$('#reportes-devoluciones-desde-days').focus();
				valid = false;
			}else if($('#reportes-devoluciones-hasta-days').val() == ""){
				$('#reportes-devoluciones-hasta-days').focus();
				valid = false;
			}else{
				fechadesde = $('#reportes-devoluciones-desde-days').val();
				fechahasta = $('#reportes-devoluciones-hasta-days').val();
			}
		}
		if(valid){
			$.get('<?php echo base_url();?>reportes/grafico_devoluciones?fechadesde='+fechadesde+'&fechahasta='+fechahasta+'&tipo='+$('#reportes-devoluciones-tipo').val()+'&valores='+valores)
			.done(function(data){                
				$('.devoluciones-ajax-content').html(data);
			});
		}else{
			toastr.options = {
			  "closeButton": true,
			  "progressBar": true,
			  "positionClass": "toast-top-right"
			}
			toastr.error('Hace falta informacion necesaria para enviar el formulario, favor verifique');
		}		
	});
	
	$('#reportes-devoluciones-tipo').change(function(){
		if($(this).val()=='mensual'){
			$('#reportes-devoluciones-desde-month, #reportes-devoluciones-hasta-month').val('');
			$('#reportes-devoluciones-desde-days, #reportes-devoluciones-hasta-days').val('');
			
			$('#reportes-devoluciones-desde-month, #reportes-devoluciones-hasta-month').show();
			$('#reportes-devoluciones-desde-days, #reportes-devoluciones-hasta-days').hide();
		}else{
			$('#reportes-devoluciones-desde-month, #reportes-devoluciones-hasta-month').val('');
			$('#reportes-devoluciones-desde-days, #reportes-devoluciones-hasta-days').val('');
			
			$('#reportes-devoluciones-desde-month, #reportes-devoluciones-hasta-month').hide();
			$('#reportes-devoluciones-desde-days, #reportes-devoluciones-hasta-days').show();
		}
	});
	$('#reportes-devoluciones-desde-month, #reportes-devoluciones-hasta-month').datepicker({
		language:'es',
		autoclose:true,
		format: "yyyy-mm", 
		startView: "months", 
		minViewMode: "months" 
	});
	var inicio_devolucion_diario = $('#reportes-devoluciones-desde-days').datepicker({
		language:'es',
		format:'yyyy-mm-dd',
		autoclose:true
	}).on('changeDate', function (ev) {
			var newDate = new Date(ev.date);
			newDate.setDate(newDate.getDate());
			fin_devolucion_diario.datepicker("update", newDate);
			$('#reportes-devoluciones-hasta-days')[0].focus();
	});
	var fin_devolucion_diario = $('#reportes-devoluciones-hasta-days').datepicker({
		language:'es',
		format:'yyyy-mm-dd',
		beforeShowDay: function (date) {
			if (!inicio_devolucion_diario.datepicker("getDate").valueOf()) {
				return date.valueOf() >= new Date().valueOf();
			} else {
				return date.valueOf() > inicio_devolucion_diario.datepicker("getDate").valueOf()-1;
			}
		},
		autoclose: true

	}).on('changeDate', function (ev) {}); 
	
	/*Proveedores*/
	$("#construirGraficoProveedor").on("click",function(){
		var valid = true;
		var fechadesde = "";
		var fechahasta = "";
		var valores = false;
		
		if($("#reportes-proveedor-mostrar").is(":checked")){
			valores = true;
		}
		
		if($('#reportes-proveedor-desde-days').val() == ""){
			$('#reportes-proveedor-desde-days').focus();
			valid = false;
		}else if($('#reportes-proveedor-hasta-days').val() == ""){
			$('#reportes-proveedor-hasta-days').focus();
			valid = false;
		}else{
			fechadesde = $('#reportes-proveedor-desde-days').val();
			fechahasta = $('#reportes-proveedor-hasta-days').val();
		}
		if(valid){
			$.get('<?php echo base_url();?>reportes/grafico_compras_proveedor?fechadesde='+fechadesde+'&fechahasta='+fechahasta+'&tipo='+$("#reportes-proveedor-tipo").val()+'&valores='+valores)
			.done(function(data){                
				$('.proveedor-ajax-content').html(data);
			});
		}else{
			toastr.options = {
			  "closeButton": true,
			  "progressBar": true,
			  "positionClass": "toast-top-right"
			}
			toastr.error('Hace falta informacion necesaria para enviar el formulario, favor verifique');
		}		
	});
	
	var inicio_proveedor= $('#reportes-proveedor-desde-days').datepicker({
		language:'es',
		format:'yyyy-mm-dd',
		autoclose:true
	}).on('changeDate', function (ev) {
			var newDate = new Date(ev.date);
			newDate.setDate(newDate.getDate());
			fin_proveedor.datepicker("update", newDate);
			$('#reportes-proveedor-hasta-days')[0].focus();
	});
	var fin_proveedor = $('#reportes-proveedor-hasta-days').datepicker({
		language:'es',
		format:'yyyy-mm-dd',
		beforeShowDay: function (date) {
			if (!inicio_proveedor.datepicker("getDate").valueOf()) {
				return date.valueOf() >= new Date().valueOf();
			} else {
				return date.valueOf() > inicio_proveedor.datepicker("getDate").valueOf()-1;
			}
		},
		autoclose: true
	});
	
	// Radialize the colors
	Highcharts.getOptions().colors = Highcharts.map(Highcharts.getOptions().colors, function (color) {
		return {
			radialGradient: {
				cx: 0.5,
				cy: 0.3,
				r: 0.7
			},
			stops: [
				[0, color],
				[1, Highcharts.Color(color).brighten(-0.3).get('rgb')] // darken
			]
		};
	});
});
</script>