var Transacciones_cortes_app=function(){
	this.baseUrl=null;
	this.windowId=null;
	this.caja=null;
	this.config={
		facturacion_documentos_disponibles:null,
	};
	/*Inicializar entorno*/
	this.initializeEnviroment=function(url,winId,caja){
		var _this=this;
		this.baseUrl=url;
		this.windowId=winId;
		this.caja=caja;
		/*Cargar configuracioenes globales*/
		jQuery.ajaxSetup({async:false});
		$.post(this.baseUrl+"administracion/cargar_configs_obj",{configs:JSON.stringify(this.config)},function(configsVal){
			_this.config=configsVal;
		},'json').fail(function(){
			alert("ERROR: No se pudieron establer valores para las configuraciones de esta aplicación, se utilizarán los valores por defecto. Contatacte a soporte técnico");
		});
		jQuery.ajaxSetup({async:true});
		/*Inicializar componentes*/
		this.initializeListeners();
	}
	/*Eventos*/
	this.initializeListeners=function(){
		var _this=this;
		/*BOTON generar corte (CLICK)*/
		$("#"+this.windowId+" #cortes-app-generar-corte-btn").click(function(e){
			if(!$(this).is(':disabled')){
				if($("#"+_this.windowId+" #cortes-app-tipo-corte").val()){
					_this.validCorte($(this),$("#"+_this.windowId+" #cortes-app-tipo-corte"),null);
				}else{
					_this.showMsg("error","Seleccione un tipo de corte");
					$("#"+_this.windowId+" #cortes-app-tipo-corte").focus();
				}
			}
		});
		/*BOTON generar corte opciones cancelar (CLICK)*/
		$("#"+this.windowId+" #cortes-app-generar-cancelar-btn").click(function(e){
			if(!$(this).is(':disabled')){
				_this.clearOptionsForm(true,true);
				$("#"+_this.windowId+" #cortes-app-generar-corte-btn").removeAttr("disabled");
				$("#"+_this.windowId+" #cortes-app-tipo-corte").removeAttr("disabled");
				$("#"+_this.windowId+" #cortes-app-tipo-corte").find("option:first").removeAttr("disabled");
				$("#"+_this.windowId+" #cortes-app-tipo-corte").find("option:first").prop("selected","selected");
				$("#"+_this.windowId+" #cortes-app-tipo-corte").find("option:first").attr("disabled","disabled");
			}
		});
		/*BOTON generar corte opciones continuar (CLICK)*/
		$("#"+this.windowId+" #cortes-app-generar-continuar-btn").click(function(e){
			if(!$(this).is(':disabled')){
				var valid=true;
				var info={
					dotacion:$("#"+_this.windowId+" #cortes-app-dotacion").val(),
					ticketSerie:$("#"+_this.windowId+" #cortes-app-resolucion").val()
				}
				var capDotacion=null;
				var capSerie=null;
				var requiredDotacion=$("#"+_this.windowId+" #cortes-app-generar-opciones-dotacion").is(":visible");
				var requiredSerie=$("#"+_this.windowId+" #cortes-app-generar-opciones-serie").is(":visible");
				var requiredMsg=$("#"+_this.windowId+" #cortes-app-generar-opciones-msg").is(":visible");
				if(requiredMsg && !requiredDotacion && !requiredSerie){
					_this.makeCorte();
				}else{
					if(requiredDotacion){
						if($("#"+_this.windowId+" #cortes-app-generar-dotacion-text").val()==""){
							_this.showMsg("error","Por favor ingrese una cantidad v&aacute; para la dotaci&oacute;n");
							$("#"+_this.windowId+" #cortes-app-generar-dotacion-text").focus();
							valid=false;
						}else{
							info.dotacion=$("#"+_this.windowId+" #cortes-app-generar-dotacion-text").val();
						}
					}
					if(requiredSerie){
						info.ticketSerie=$("#"+_this.windowId+" #cortes-app-generar-tickets-serie").val();
					}
				}
				if(valid)
					_this.validCorte($(this),$("#"+_this.windowId+" #cortes-app-tipo-corte"),info); 
			}
		});
		/*BOTON exportar/imprimir corte (CLICK)*/
		$("#"+this.windowId+" #cortes-app-exportar-imprimir").click(function(e){
			if(!$(this).is(':disabled')){
				$("#"+_this.windowId+" #cortes-app-exportar-opciones").modal("show");
			}
		});
		$("#"+this.windowId+" #cortes-app-exportar-continuar-btn").click(function(e){
			if(!$(this).is(':disabled')){
				var corte=$("#"+_this.windowId+" #corte-fiscal").is(":checked");
				var anexo1=$("#"+_this.windowId+" #corte-anexo1").is(":checked");
				var anexo2=$("#"+_this.windowId+" #corte-anexo2").is(":checked");
				var anexo3=$("#"+_this.windowId+" #corte-anexo3").is(":checked");
				var id=$("#"+_this.windowId+" #id_corte").val();
			
				if($("#"+_this.windowId+" #cortes-app-exportar-opcion").val()==0){
					url="transacciones/printcorte";
					$.get(_this.baseUrl+url,{id:id,corte:corte,anexo1:anexo1,anexo2:anexo2,anexo3:anexo3},function(dataPrint){
						if(dataPrint){
							$.post("http://localhost/miracleprint/corte.php",{
								dataPrint:dataPrint
							})
							.done(function(response){                
								
							});	
							
							$("#"+_this.windowId+" #cortes-app-exportar-opciones").modal("hide");
							_this.showMsg("info","Se ha enviado la orden");
						}
					},"text");
				}else{
					url="reportes/cortes";
					window.open(_this.baseUrl+url+"?id="+id+"&corte="+corte+"&anexo1="+anexo1+"&anexo2="+anexo2+"&anexo3="+anexo3,"_blank");
					$("#"+_this.windowId+" #cortes-app-exportar-opciones").modal("hide");
				}		
				
			}
		});
	},
	/*Funciones*/
	/*Cargar opciones de corte para estado de caja*/
	this.loadOptions=function(estadoCaja){
		if(estadoCaja=="0"){/*Inactiva*/
			$("#"+this.windowId+" #cortes-app-tipo-corte option[value='1']").remove();
			$("#"+this.windowId+" #cortes-app-tipo-corte option[value='2']").remove();
		}else if(estadoCaja=="1"){/*Activa*/
			$("#"+this.windowId+" #cortes-app-tipo-corte option[value='0']").remove();
			$("#"+this.windowId+" #cortes-app-tipo-corte option[value='3']").remove();
		}
	},
	/*Validar corte*/
	this.validCorte=function($sender,$typeWrapper,info){
		$sender.prop("disabled","disabled");
		$typeWrapper.prop("disabled","disabled");
		this.clearOptionsForm(true,true);
		var _this=this;
		var type=parseInt($typeWrapper.val());
		var okTicketSerie=true;
		var okDotacion=true;
		var okMsg=true;
		var ticketSerie="na";
		var dotacion="na"
		var msg="";
		/*Mostrar ventana de opciones - modo procesando*/
		$("#"+this.windowId+" #cortes-app-generar-opciones").modal("show");
		$("#"+this.windowId+" #cortes-app-generar-opciones-loading").show();
		$("#"+this.windowId+" #cortes-app-generar-opciones-wrapper").hide();
		/*información de cortes*/
		if(info)
			infoCorte=info;
		else{
			infoCorte={};
		}
		/*Verificar serie de ticket*/
		if(!infoCorte.ticketSerie || infoCorte.ticketSerie==''){
			/*Chequear documentos de facturacion disponibles*/
			if(this.config.facturacion_documentos_disponibles!=null){
				var ticket=this.config.facturacion_documentos_disponibles.indexOf("3");
				if(ticket>=0){
					/*Obtener resoluciones/series para tickets*/
					jQuery.ajaxSetup({async:false});
					if(!infoCorte.resolucion || infoCorte.resolucion==''){
						$.get(this.baseUrl+"administracion/resolucionesxdoc",{doc:3,caja:this.caja,activas:true},function(series){
							if(series){
								if(series.length==1){
									ticketSerie=series[0].id;
								}
								else if(series.length>1){
									okTicketSerie=false;
									/*Cargar series disponibles en select*/
									$("#"+_this.windowId+" #cortes-app-generar-tickets-serie option").remove();
									for(var i=0;i<series.length;i++){
										$("#"+_this.windowId+" #cortes-app-generar-tickets-serie").append($('<option>',{ 
											value:series[i].id,
											text:series[i].serie
										}));
									}
								}
							}
							else{/*Si hay ticket pero no se reconocen la series*/
								okMsg=false;
								msg="No se ha encontrado una serie activa para tickets en esta caja, es posible que no se haya asignado una serie o se encuentre agotado el tiraje, por favor verifique";
							}
						},'json');
					}
					jQuery.ajaxSetup({async:true});
				}
			}
			else{/*No es posible leer los documentos disponibles*/
				okMsg=false;
				msg="No es posible determinar que documentos estan disponibles para facturación. El corte se realizará con los documentos conocidos, por favor contacte a soporte técnico";
				/*Buscar una serie activa para tickets en esta caja*/
				jQuery.ajaxSetup({async:false});
				$.get(this.baseUrl+"administracion/resolucionesxdoc",{doc:3,caja:this.caja,activas:true},function(series){
					if(series){
						if(series.length==1){
							ticketSerie=series[0].id;
						}else if(series.length>1){
							okTicketSerie=false;
							/*Cargar series disponibles en select*/
							$("#"+_this.windowId+" #cortes-app-generar-tickets-serie option").remove();
							for(var i=0;i<series.length;i++){
								$("#"+_this.windowId+" #cortes-app-generar-tickets-serie").append($('<option>',{ 
									value:series[i].id,
									text:series[i].serie
								}));
							}
						}
					}
				},'json');
				jQuery.ajaxSetup({async:true});
			}
		}
		else{
			 ticketSerie=infoCorte.ticketSerie;
		}
		/*Verificar dotación para corte x iniciarl*/
		if(type===0){
			if(!infoCorte.dotacion || infoCorte.dotacion==''){
				okDotacion=false;
			}else{
				dotacion=infoCorte.dotacion;
			}
		}
		$("#"+this.windowId+" #cortes-app-dotacion").val(dotacion);
		$("#"+this.windowId+" #cortes-app-resolucion").val(ticketSerie);
		
		
		/*Procesar cortes*/
		if(okTicketSerie && okDotacion && okMsg){
			this.makeCorte();
		}else{
			var $focus=null;
			/*Cambiar ventana de opciones a modo captura de datos*/
			$("#"+this.windowId+" #cortes-app-generar-opciones-loading").hide();
			$("#"+this.windowId+" #cortes-app-generar-opciones-wrapper").show();
			$("#"+this.windowId+" #cortes-app-generar-cancelar-btn").show();
			$("#"+this.windowId+" #cortes-app-generar-continuar-btn").show();
			this.clearOptionsForm(false,true);
			if(!okTicketSerie){
				$("#"+this.windowId+" #cortes-app-generar-opciones-serie").show();
				$focus=$("#"+this.windowId+" #cortes-app-generar-tickets-serie");
			}
			if(!okDotacion){
				$("#"+this.windowId+" #cortes-app-generar-opciones-dotacion").show();
				$focus=$("#"+this.windowId+" #cortes-app-generar-dotacion-text");
			}
			if(!okMsg){
				$("#"+this.windowId+" #cortes-app-generar-opciones-msg").show();
				$("#"+this.windowId+" #cortes-app-generar-opciones-msg").text(msg);
				$focus=$("#"+this.windowId+" #cortes-app-generar-continuar-btn");
			}	
			if(focus){
				setTimeout(function(){$focus.focus();},800);
			}
		}		
	},
	/*Hace corte*/
	this.makeCorte=function(){
		
		/*Cambiar a modo procesando*/
		$("#"+this.windowId+" #cortes-app-generar-opciones-wrapper").hide();
		$("#"+this.windowId+" #cortes-app-generar-opciones-loading").show();
		$("#"+this.windowId+" #cortes-app-generar-opciones-loading-status").text('Procesando...');
		$("#"+this.windowId+" #cortes-app-generar-cancelar-btn").hide();
		$("#"+this.windowId+" #cortes-app-generar-continuar-btn").hide();
		var _this=this;
		/**/
		$.get(this.baseUrl+"transacciones/makecorte",{tipo:$("#"+this.windowId+" #cortes-app-tipo-corte").val(),dotacion:$("#"+this.windowId+" #cortes-app-dotacion").val(),serie:$("#"+this.windowId+" #cortes-app-resolucion").val()},function(cortes){
			$("#"+_this.windowId+" #cortes-app-generar-opciones").modal("hide");
			$("#"+_this.windowId+" #cortes-app-corte-wrapper").html(cortes);
		},"html");
	},
	/*Limpiar formulario*/
	this.clearOptionsForm=function(clear,hide){
		if(clear){
			$("#"+this.windowId+" #cortes-app-generar-opciones-msg").text("");
			$("#"+this.windowId+" #cortes-app-generar-dotacion-text").val("");
			$("#"+this.windowId+" #cortes-app-generar-tickets-serie option").remove();
			$("#"+this.windowId+" #cortes-app-generar-tickets-serie").val("");
			
			$("#"+this.windowId+" #cortes-app-dotacion").val("");
			$("#"+this.windowId+" #cortes-app-resolucion").val("");
		}
		if(hide){
			$("#"+this.windowId+" #cortes-app-generar-opciones-msg").hide();
			$("#"+this.windowId+" #cortes-app-generar-opciones-dotacion").hide();
			$("#"+this.windowId+" #cortes-app-generar-opciones-serie").hide();
		}
	},
	/*Mostar mensaje*/
	this.showMsg=function(tipo, mensaje){
		toastr.options = {
			"closeButton": true,
			"progressBar": true,
			"positionClass": "toast-top-right"
		}
		toastr[tipo](mensaje);
	}
}