var Transacciones_facturacion_app=function(){
	this.baseUrl=null;
	this.windowId=null;
	this.Transtools=null;
	this.venta=null;
	this.caja=null;
	this.defaultValues=null;
	this.config={
		transacciones_validar_precio:null,
		transacciones_validar_existencia:null,
		transacciones_validar_cliente:null,
		transacciones_validar_credito_transitorios:null,
		transacciones_validar_contado_facturados:null,
		transacciones_validar_existencia_trans:null
	};
	/*Inicializar entorno*/
	this.initializeEnviroment=function(url,winId,caja){
		var _this=this;
		this.baseUrl=url;
		this.windowId=winId;
		this.caja=caja;
		/*Cargar configuracioenes globales*/
		jQuery.ajaxSetup({async:false});
		$.post(this.baseUrl+"administracion/cargar_configs_obj",{configs:JSON.stringify(this.config)},function(configsVal){
			_this.config=configsVal;
		},'json').fail(function(){
			alert("ERROR: No se pudieron establer valores para las configuraciones de esta aplicación, se utilizarán los valores por defecto. Contatacte a soporte técnico");
		});
		jQuery.ajaxSetup({async:true});
		/*Inicializar componentes*/
		this.initializeGUIComponets();
		this.initializeTools();
		this.initializeListeners();
		this.initializeHotKeys();
	},
	/*Establecer valores por defecto*/
	this.setDefaults=function(defaults,apply,focus){
		this.defaultValues=defaults;
		this.defaultFocus=focus;
		if(apply){
			this.fillForm(defaults,null,focus);
		}else{
			this.defaultFocus.focus();
		}
	},
	/*Inicializar componentes de la interfaz*/
	this.initializeGUIComponets=function(){
		/*modales*/
		$("#"+this.windowId+" #nueva-venta-cliente-docs").addClass("modal");
		$("#"+this.windowId+" #nueva-venta-credito").addClass("modal");
		$("#"+this.windowId+" #nueva-venta-forma-pago").addClass("modal");
		$("#"+this.windowId+" #nueva-venta-confirmar").addClass("modal");
		/*mascaras*/		
		$("#"+this.windowId+" #nueva-venta-cliente-dui").inputmask({mask:"[99999999-9]"});
		$("#"+this.windowId+" #nueva-venta-cliente-nit").inputmask({mask:"[9999-999999-999-9]"});
		$("#"+this.windowId+" #credito-fecha-limite-wrapper .input-group.date,#"+this.windowId+" #nueva-venta-fecha").datepicker({
			language:'es',
			autoclose:true,
			format:'yyyy-mm-dd',
		});
	}
	/*Inicializar clase de apoyo*/
	this.initializeTools=function(){
		/*Transaciones*/
		this.Transtools=new Transaccionestools(this.baseUrl);
		this.Transtools.setProductFrame($("#"+this.windowId+" #nueva-venta-producto-info"));
		this.Transtools.setProductTable($("#"+this.windowId+"  #nueva-venta-productos-wrapper > table"));
		this.Transtools.setTotalTable($("#"+this.windowId+" #nueva-venta-totales-wrapper"));
		this.Transtools.SetTotalsProfile('grabadas,nosujetas,exentas,descuentos,total','grabadas|+|nosujetas|+|exentas|-|descuentos',true);
		/*Llaves*/
		this.keys=new Keys();
		/*Ventas*/
		this.venta=new Ventas();
		this.venta.setUrl(this.baseUrl);
		this.venta.setConfig(this.config);
	},
	/*Eventos*/
	this.initializeListeners=function(){
		var _this=this;
		/*Seleccionar producto click*/
		$("#"+this.windowId+" #nueva-venta-productos-wrapper").on("click","table tr",function(){
			var dataClick = $(this);
			$("#"+_this.windowId+" #nueva-venta-productos-wrapper .miracle-selected-table-item").removeClass('miracle-selected-table-item');
			dataClick.addClass('miracle-selected-table-item');
		});
		/*BOTON agregar/quitar cliente  (CLICK)*/
		$("#"+this.windowId+" #nueva-venta-cliente-buscar-btn").click(function(e){
			e.preventDefault();
			_this.setCliente($(this));
		});
		/*SELECT documento venta (CHANGE)*/
		$("#"+this.windowId+" #nueva-venta-documento").change(function(){
			$("#"+_this.windowId+" #nueva-venta-documento-numero").removeAttr("readonly");
			_this.setAutoNumDoc($.trim($(this).val()),true);
			_this.updatePriceProfile(true);
		});
		/*SELECT serie documento venta (CHANGE)*/
		$("#"+this.windowId+" #nueva-venta-documento-serie").change(function(){
			_this.setNumDoc();			
		});
		/*BOTON cargar venta*/
		$("#"+this.windowId+" #nueva-venta-cargar-btn").click(function(e){
			if(!$(this).is(':disabled') && $("#"+_this.windowId+" #nueva-venta-cargar-text").val()!=""){
				if($(this).attr("data-function")=="set"){
					_this.cargarTransaccion($("#"+_this.windowId+" #nueva-venta-cargar-text"),$(this));
					$(this).removeClass("btn-info");
					$(this).addClass("btn-danger");
					$(this).find("i").removeClass("fa-check");
					$(this).find("i").addClass("fa-times");
					$(this).attr("data-function","unset");
					_this.defaultFocus=$("#"+_this.windowId+" #nueva-venta-cargar-text");
				}else{
					_this.defaultFocus=$("#"+_this.windowId+" #nueva-venta-producto-sku");
					_this.resetForm();
				}
			}
		});
		/*BOTON buscar producto (CLICK)*/
		$("#"+this.windowId+" #ventas-buscar-producto-btn").click(function(e){
			e.preventDefault();
			Custombox.open({
				target:_this.baseUrl+"productos/buscarproductos?field=nueva-venta-producto-sku&enter=true"
			});
		});
		/*TEXTBOX cargar info producto (ENTER)*/
		$("#"+this.windowId+" #nueva-venta-producto-sku").keyup(function(e){
			if(e.which==38 || e.keyCode==38){
				e.preventDefault();
				_this.goTop();
			}else if(e.which==40 || e.keyCode==40){
				e.preventDefault();
				_this.goBottom();
			}else if((e.which==13 || e.keyCode==13) && $.trim($(this).val())!=""){
				e.preventDefault();
				_this.Transtools.getProductInfoBySKU('tipo_producto,tipo_venta,descripcion,precios,unidades,existencias,interno,referencia',$(this).val(),$("#"+_this.windowId+" #nueva-venta-producto-cant"),$("#"+_this.windowId+" #nueva-venta-producto-sku"));
			}else if(e.which==115 || e.keyCode==115){
				if($("#"+_this.windowId).is(":visible")){
					e.preventDefault();
					var tr=$("#"+_this.windowId+" #nueva-venta-productos-wrapper").find(".miracle-selected-table-item");
					_this.Transtools.removeProductToTable($(tr));
					_this.revisarExistencias();
					$("#"+_this.windowId+" #nueva-venta-productos-wrapper").find("tr").first().addClass("miracle-selected-table-item");
				}
			}else if(e.which==35 || e.keyCode==35){
				if($("#"+_this.windowId).is(":visible")){
					e.preventDefault();
					var tr=$("#"+_this.windowId+" #nueva-venta-productos-wrapper").find(".miracle-selected-table-item");
					tr.find(".table-cant").trigger("dblclick");
				}
			}else if(e.which==45 || e.keyCode==45){
				if($("#"+_this.windowId).is(":visible")){
					e.preventDefault();
					var tr=$("#"+_this.windowId+" #nueva-venta-productos-wrapper").find(".miracle-selected-table-item");
					tr.find(".table-precio").trigger("dblclick");
				}
			}
		});
		/*TEXTBOX cantidad (KEYUP)*/
		$("#"+this.windowId+" #nueva-venta-producto-cant").keyup(function(e){
			_this.calcSingleTotal($(this).val(),$("#"+_this.windowId+" #nueva-venta-producto-costo").val(),$("#"+_this.windowId+" #nueva-venta-producto-total"));
		});
		/*TEXTBOX cantidad (KEYUP)*/
		$("#"+this.windowId+" #nueva-venta-producto-total").keyup(function(e){
			_this.calcDescuento($(this).val(),$("#"+_this.windowId+" #nueva-venta-producto-costo").val(),$("#"+_this.windowId+" #nueva-venta-producto-descuento"));
		});
		/*BOTON navegar precios (CLICK)*/
		$("#"+this.windowId+" .price-navigation-btn").click(function(){
			_this.Transtools.pricesNavigation($(this).attr('data-role'));
			_this.calcSingleTotal($("#"+_this.windowId+" #nueva-venta-producto-cant").val(),$("#"+_this.windowId+" #nueva-venta-producto-costo").val(),$("#"+_this.windowId+" #nueva-venta-producto-total"));
		});
		/*TEXTBOX precio (KEYUP)*/
		$("#"+this.windowId+" #nueva-venta-producto-costo").keyup(function(e){
			_this.calcSingleTotal($("#"+_this.windowId+" #nueva-venta-producto-cant").val(),$(this).val(),$("#"+_this.windowId+" #nueva-venta-producto-total"));
		});
		/*BOTON agregar producto a la tabla (CLICK)*/
		$("#"+this.windowId+" #nueva-venta-producto-agregar").click(function(e){
			_this.addProductToTable(null,null);
		});
		/*BOTON quitar producto a la tabla (CLICK)*/
		$("#"+this.windowId+" #nueva-venta-productos-wrapper").on('click','table tr td.table-del',function(){
			var tr=$(this).closest('tr');
			_this.Transtools.removeProductToTable($(tr));
			_this.revisarExistencias();
		});
		/*Editar cantidad (Doble CLICK)*/
		$("#"+this.windowId+" #nueva-venta-productos-wrapper").on('dblclick','table tr td.table-cant',function(){
			var tr=$(this);
			tr.html("<input type='text' style='color:#000;' class='form-control table-cant-edit' value='"+tr.attr("data-value")+"'>");
			tr.find("input").focus();
		});
		
		$("#"+this.windowId+" #nueva-venta-productos-wrapper").on('keypress','table tr td input.table-cant-edit',function(e){
			$el = $(this);
			if(e.which == 13){
				if($.trim($el.val())!="" && $el.val() > 0){
					var servicioCant=$el.val();
					var servicioCosto=$el.closest("tr").find(".table-precio").attr("data-value");
					var servicioTotal=parseFloat(servicioCant)*parseFloat(servicioCosto);
					$el.closest("tr").find(".table-total").attr("data-value",parseFloat(servicioTotal).toFixed(4)).html(servicioTotal.toFixed(4));
					$el.closest("td").attr("data-value",$el.val()).html($el.val());
					_this.Transtools.calcTotals();
					$("#"+_this.windowId+" #nueva-venta-producto-sku").focus();
				}else{
					toastr.options = {
						"closeButton": true,
						"progressBar": true,
						"positionClass": "toast-top-right"
					}
					toastr["error"]("Ingrese una cantidad valida");
				}
			}
		});
		/*Editar precio (Doble CLICK)*/
		$("#"+this.windowId+" #nueva-venta-productos-wrapper").on('dblclick','table tr td.table-precio',function(){
			var tr=$(this);
			tr.html("<input type='text' style='color:#000;' class='form-control table-precio-edit' value='"+tr.attr("data-value")+"'>");
			tr.find("input").focus();
		});
		$("#"+this.windowId+" #nueva-venta-productos-wrapper").on('keypress','table tr td input.table-precio-edit',function(e){
			$el = $(this);
			if(e.which == 13){
				if($.trim($el.val())!="" && $el.val() > 0){
					var servicioCosto=$el.val();
					var servicioCant=$el.closest("tr").find(".table-cant").attr("data-value");
					var servicioTotal=parseFloat(servicioCant)*parseFloat(servicioCosto);
					$el.closest("tr").find(".table-total").attr("data-value",parseFloat(servicioTotal).toFixed(4)).html(servicioTotal.toFixed(4));
					$el.closest("td").attr("data-value",$el.val()).html($el.val());
					_this.Transtools.calcTotals();
					$("#"+_this.windowId+" #nueva-venta-producto-sku").focus();
				}else{
					toastr.options = {
						"closeButton": true,
						"progressBar": true,
						"positionClass": "toast-top-right"
					}
					toastr["error"]("Ingrese un precio valido");
				}
			}
		});
		/*BOTON autorizar uso existencias insuficientes*/
		$("#"+this.windowId).on("click","#nueva-venta-no-existencias-msg #nueva-venta-no-existencia-autorizar-btn",function(){
			_this.autorizarExistencias(false);
		});
		/*LINK Revertir autorizacion de uso de existencias insuficientes*/
		$("#"+this.windowId).on("click","#nueva-venta-no-existencias-revertir-link",function(e){
			e.preventDefault();
			swal({
				title: "Revertir autorizaci&oacute;n",
				text: " &iquest;Desea retirar la autorizaci&oacute;n de uso de existencias insuficientes?",
				type: "warning",
				html: true,
				showCancelButton: true,
				confirmButtonColor: "#DD6B55",
				confirmButtonText: "Si, Revertir",
				cancelButtonText: "No",
				closeOnConfirm: true,
				closeOnCancel: true
			},
			function(isConfirm){
				if (isConfirm) {
					$("#"+_this.windowId+" #nueva-venta-existencias-ok").val("1"); /*quitar estado de existencias autorizadas*/
					_this.revisarExistencias();
				}
			});
		});
		/*BOTON guardar venta (CLICK)*/
		$("#"+this.windowId+" #guardar-venta-btn").click(function(){
			if(!$(this).is(':disabled')){
				if($(".table-cant-edit").length > 0){
					toastr.options = {
						"closeButton": true,
						"progressBar": true,
						"positionClass": "toast-top-right"
					}
					toastr["error"]("Tiene cantidades pendientes de guardar");
					$(".table-cant-edit:first").focus();
				}else if($(".table-precio-edit").length > 0){
					toastr.options = {
						"closeButton": true,
						"progressBar": true,
						"positionClass": "toast-top-right"
					}
					toastr["error"]("Tiene precios pendientes de guardar");
					$(".table-precio-edit:first").focus();
				}else{
					_this.venta.validarVenta($(this));					
				}
			}
		});
		/*BOTON colocar documentos (CLICK)*/
		$("#"+this.windowId+" #nueva-venta-doc-guardar-btn").click(function(){
			if(!$(this).is(':disabled'))
				_this.venta.validarVenta($(this));
		});
		/*MODAL Cerrar modal documentos (EVENTO)*/
		$("#"+this.windowId+" #nueva-venta-cliente-docs").on("hidden.bs.modal",function(e){
			_this.venta.cancelarValidarVenta("docscliente");
		});
		/*CHECKBOX ELEGIR entre nuevo y sel credito (CHANGE)*/
		$("#"+this.windowId+" .crediaccion input:radio").on("change",function(event){
			$("#"+_this.windowId+" #creditos-cliente-select-list-wrapper > div").hide();
			$($(this).attr('data-display')).show();
			$("#"+_this.windowId+" .creditoradio input:radio").attr("checked", false);
			/* $('.creditoradio input:radio').iCheck('update'); */
			if($(this).attr('data-display')=="#creditos-cliente-list"){
				$($(this).attr('data-display')).html("<div style='text-align:center;margin-top:21px;'><i class='fa fa-spinner'></i><br><small class='text-muted'>Cargando creditos...</small></div>");
				$.get(_this.baseUrl+"clientes/creditosxclientemin",{cliente:$.trim($("#nueva-venta-cliente").val())},function(creditos){
					$("#"+_this.windowId+" #creditos-cliente-list").html(creditos);
				});
			} 
		});
		/**RADIO BUTTON elegir dias de credito (CHANGE)**/
		$("#"+this.windowId+" #credito-dias-credito input:radio").on("change",function(event){
			var diasCred=parseInt($(this).val());
			var date=new Date();
			$("#"+_this.windowId+" #credito-fecha-limite-wrapper .input-group.date").datepicker('setDate', new Date(date.setTime(date.getTime()+diasCred*86400000)));
		});
		/*BOTON Colocar informacion de credito (CLICK)*/
		$("#"+this.windowId+" #nueva-venta-credito-guardar-btn").click(function(){
			if(!$(this).is(':disabled')){
				if($("#"+_this.windowId+" #crediaccion-nuevo").is(":checked")){
					$("#"+_this.windowId+" #credito-venta").val('CREATE');
					if(!$.trim($("#"+_this.windowId+" #credito-fecha-limite").val())==""){
						$("#"+_this.windowId+" #ncredito-fecha-limite").val($("#"+_this.windowId+" #credito-fecha-limite").val());			
						alert($("#"+_this.windowId+" #credito-dias-credito input[name=diascred]:checked").val());						
						$("#"+_this.windowId+" #ncredito-dias").val($("#"+_this.windowId+" #credito-dias-credito input[name=diascred]:checked").val());
					}
					$("#"+_this.windowId+" #forma-pago").val("0");
					_this.venta.validarVenta($(this));
				}else if($("#"+_this.windowId+" #crediaccion-cargar").is(":checked")){
					if ($("#"+_this.windowId+" input[name='deuda']:checked").val()) {
						var selRadio=$("#"+_this.windowId+" input[name='deuda']:checked"); 
						var CreditoID=selRadio.closest("tr").attr("data-deuda");
						$("#"+_this.windowId+" #credito-venta").val(CreditoID);
						$("#"+_this.windowId+" #forma-pago").val('0');
						_this.venta.validarVenta($(this));
					}
					else {
						 toastr.options = {
							"closeButton": true,
							"progressBar": true,
							"positionClass": "toast-top-right"
						}
						toastr.error('Seleccione un cr&eacute;dito de la lista para continuar...');
					}
				}
			}
		});
		/*MODAL Cerrar modal creditos (EVENTO)*/
		$("#"+this.windowId+" #nueva-venta-credito").on("hidden.bs.modal",function(e){
			$("#"+_this.windowId+" #creditos-cliente-list").css("display","none");
			$("#"+_this.windowId+" #crediaccion-nuevo").prop("checked","checked");$(".crediaccion input:radio").iCheck("update");
			_this.venta.cancelarValidarVenta("creditos");
		});
		/*SELECT Cambiar forma de pago (CHANGE)*/
		$("#"+this.windowId+" #nueva-venta-forma-pago-select").change(function(){
			if($(this).val()==1){
				$("#"+_this.windowId+" #nueva-venta-efectivo-frame").show();
				$("#"+_this.windowId+" #nueva-venta-mixto-frame").hide();
				$("#"+_this.windowId+" #nueva-venta-forma-pago-efectivo").focus();
			}else if($(this).val()==6){
				$("#"+_this.windowId+" #nueva-venta-mixto-frame").show();
				$("#"+_this.windowId+" #nueva-venta-efectivo-frame").hide();
				$("#"+_this.windowId+" #nueva-venta-forma-pago-efectivo-mixto").focus();
			}else{
				$("#"+_this.windowId+" #nueva-venta-efectivo-frame").hide();
				$("#"+_this.windowId+" #nueva-venta-mixto-frame").hide();
				$("#"+_this.windowId+" #nueva-venta-fpago-guardar-btn").focus();
			}
		});
		/*SELECT Cambiar forma de pago (CHANGE)*/
		/* $("#"+this.windowId+" #nueva-venta-forma-pago-efectivo").keyup(function(){
			$("#nueva-venta-forma-pago-cambio").val((parseFloat($(this).val()-parseFloat($('#nueva-venta-totales-wrapper .totalTotal .totalval').attr('data-value')))).toFixed(2));
		}); */
		/*TEXTBOX Calcular cambio (KEYUP)*/
		$("#"+this.windowId+" #nueva-venta-forma-pago-efectivo").keyup(function(){
			$("#"+_this.windowId+" #nueva-venta-forma-pago-cambio").val((parseFloat($(this).val()-parseFloat($("#"+_this.windowId+" #nueva-venta-totales-wrapper .totalTotal .totalval").attr("data-value")))).toFixed(2));
		});
		$("#"+this.windowId+" #nueva-venta-forma-pago-efectivo-mixto").keyup(function(){
			_this.calcCambioMixto($(this).val());
		});
		$("#"+this.windowId+" #nueva-venta-forma-pago-pos-mixto").keyup(function(){
			_this.calcCambioMixto($("#"+_this.windowId+" #nueva-venta-forma-pago-efectivo-mixto").val());
		});
		/*BOTON Colocar forma pago */
		$("#"+this.windowId+" #nueva-venta-fpago-guardar-btn").click(function(){
			if(!$(this).is(':disabled')){
				if($("#"+_this.windowId+" #nueva-venta-forma-pago-select").val()==6){
					$("#"+_this.windowId+" #forma-pago").val($("#"+_this.windowId+" #nueva-venta-forma-pago-select").val());
					$("#"+_this.windowId+" #efectivo-venta").val($.trim($("#"+_this.windowId+" #nueva-venta-forma-pago-efectivo-mixto").val()));
					$("#"+_this.windowId+" #pos-venta").val($.trim($("#"+_this.windowId+" #nueva-venta-forma-pago-pos-mixto").val()));
					$("#"+_this.windowId+" #cambio-venta").val($.trim($("#"+_this.windowId+" #nueva-venta-forma-pago-cambio-mixto").val()));
					_this.venta.validarVenta($(this));
				}else{
					$("#"+_this.windowId+" #forma-pago").val($("#"+_this.windowId+" #nueva-venta-forma-pago-select").val());
					$("#"+_this.windowId+" #efectivo-venta").val($.trim($("#"+_this.windowId+" #nueva-venta-forma-pago-efectivo").val()));
					$("#"+_this.windowId+" #pos-venta").val("0.00");
					$("#"+_this.windowId+" #cambio-venta").val($.trim($("#"+_this.windowId+" #nueva-venta-forma-pago-cambio").val()));
					_this.venta.validarVenta($(this));
				}
			}
		});
		/*MODAL Cerrar modal forma de pago (EVENTO)*/
		$("#"+this.windowId+" #nueva-venta-forma-pago").on('hidden.bs.modal', function(e){
			_this.venta.cancelarValidarVenta("formapago");
		});
		/*BOTON Confirmar Guarda venta (CLICK)*/
	 	$("#"+this.windowId+" #nueva-venta-confirmar-guardar-btn").click(function(){
			if(!$(this).is(':disabled'))
				_this.venta.processVenta();
		});
		/*BOTON Cancelar Guardar venta (CLICK)*/
		$("#"+this.windowId+" #nueva-venta-cancelar-guardar-btn").click(function(){
			if(!$(this).is(':disabled'))
				_this.venta.cancelarValidarVenta("confirmar");
		});
		/*BOTON Nueva venta - reset(CLICK)*/
		$("#"+this.windowId+" #nueva-venta-reset-btn").click(function(){
			$("#"+_this.windowId+" #nueva-venta-confirmar").modal("hide");
			_this.resetForm();
		});
		/*BOTON Salir Nueva venta (CLICK)*/
		$("#"+this.windowId+" #nueva-venta-confirmar-salir-btn").click(function(){
			$("#"+_this.windowId+" #nueva-venta-confirmar").modal("hide");
			$("#"+_this.windowId+" #nueva-venta-confirmar").on('hidden.bs.modal', function(){
				setTimeout(function(){Custombox.close();}, 100);
			});
		});
	},
	this.calcCambioMixto=function(efectivo){
		var _this = this;
		var total=parseFloat($("#"+_this.windowId+" #nueva-venta-totales-wrapper .totalTotal .totalval").attr("data-value"));
		var pos=$("#"+_this.windowId+" #nueva-venta-forma-pago-pos-mixto").val();
		var cambio=parseFloat(efectivo)-(parseFloat(total)-parseFloat(pos));
		$("#"+_this.windowId+" #nueva-venta-forma-pago-cambio-mixto").val(cambio.toFixed(2));
	}
	/*HOTKEYS*/
	this.initializeHotKeys=function(){
		var _this=this;
		/*DOCUMENT FocoSKU*/
		$(document).bind("keydown", "home", function(e){
			if($("#"+_this.windowId).is(":visible")){
				e.preventDefault();
				$("#"+_this.windowId+" #nueva-venta-producto-sku").focus();
			}
		});
		/*TEXTBOX Buscar cliente (F3)*/
		$("#"+this.windowId+" .form-control").bind("keydown", "home", function(e){
			if($("#"+_this.windowId).is(":visible")){
				e.preventDefault();
				$("#"+_this.windowId+" #nueva-venta-producto-sku").focus();
			}
		});
		/*DOCUMENT eliminar producto (F4)*/
		$(document).bind('keydown', 'f4', function(e){
			if($("#"+_this.windowId).is(":visible")){
				e.preventDefault();
				var tr=$("#"+_this.windowId+" #nueva-venta-productos-wrapper").find(".miracle-selected-table-item");
				_this.Transtools.removeProductToTable($(tr));
				_this.revisarExistencias();
			}
		});
		/*DOCUMENT Buscar cliente (F3)*/
		$(document).bind("keydown", "f3", function(e){
			if($("#"+_this.windowId).is(":visible")){
				e.preventDefault();
				$("#"+_this.windowId+" #nueva-venta-cliente-buscar-btn").trigger("click");
			}
		});
		$("#"+this.windowId+" #hotkey-buscar-cliente-btn").on("click", function(e){
			e.preventDefault();
			if($("#"+_this.windowId).is(":visible")){
				e.preventDefault();
				$("#"+_this.windowId+" #nueva-venta-cliente-buscar-btn").trigger("click");
			}
		});
		/*DOCUMENT Vendedor (F9)*/
		$("#"+this.windowId+" .form-control").bind("keydown", "f9", function(e){
			if($("#"+_this.windowId).is(":visible")){
				e.preventDefault();
				$("#"+_this.windowId+" #nueva-venta-vendedor-id").trigger("focus");
			}
		});
		/*DOCUMENT Vendedor (F9)*/
		$(document).bind("keydown", "f3", function(e){
			if($("#"+_this.windowId).is(":visible")){
				e.preventDefault();
				$("#"+_this.windowId+" #nueva-venta-vendedor-id").trigger("focus");
			}
		});
		$("#"+this.windowId+" #hotkey-seleccionar-vendedor-btn").on("click", function(e){
			e.preventDefault();
			if($("#"+_this.windowId).is(":visible")){
				e.preventDefault();
				$("#"+_this.windowId+" #nueva-venta-vendedor-id").trigger("focus");
			}
		});
		/*TEXTBOX Buscar cliente (F3)*/
		$("#"+this.windowId+" .form-control").bind("keydown", "f3", function(e){
			if($("#"+_this.windowId).is(":visible")){
				e.preventDefault();
				$("#"+_this.windowId+" #nueva-venta-cliente-buscar-btn").trigger("click");
			}
		});
		/*TEXTBOX Nombre del cliente (ENTER)*/
		$("#"+_this.windowId+" #nueva-venta-cliente-text").bind("keydown", "return", function(e){
			e.preventDefault();
			$("#"+_this.windowId+" #nueva-venta-condicion").focus();
		});
		/*SELECT condicion (ENTER)*/
		$("#"+this.windowId+" #nueva-venta-condicion").bind("keydown", "return", function(e){
			e.preventDefault();
			 $("#"+_this.windowId+" #nueva-venta-documento").focus();
		});
		/*SELECT Documento (ENTER)*/
		$("#"+this.windowId+" #nueva-venta-documento").bind("keydown", "return", function(e){
			e.preventDefault();
			if($("#"+_this.windowId+" #nueva-venta-documento-serie option").size()>1)
				$("#"+_this.windowId+" #nueva-venta-documento-serie").focus();
			else{
				if(!$("#"+_this.windowId+" #nueva-venta-documento-numero").is(":disabled") && !$("#"+_this.windowId+" #nueva-venta-documento-numero").is("[readonly]"))
					$("#"+_this.windowId+" #nueva-venta-documento-numero").focus();
				else
					$("#"+_this.windowId+" #nueva-venta-producto-sku").focus();
			}
		});
		/*SELECT serie (ENTER)*/
		$("#"+this.windowId+" #nueva-venta-documento-serie").bind("keydown", "return", function(e){
			e.preventDefault();
			if(!$("#"+_this.windowId+" #nueva-venta-documento-numero").is(":disabled") && !$("#"+_this.windowId+" #nueva-venta-documento-numero").is("[readonly]"))
				$("#"+_this.windowId+" #nueva-venta-documento-numero").focus();
			else
				$("#"+_this.windowId+" #nueva-venta-producto-sku").focus();
		});
		/*SELECT Numero documento (ENTER)*/
		$("#"+this.windowId+" #nueva-venta-documento-numero").bind("keydown", "return", function(e){
			e.preventDefault();
			$("#"+_this.windowId+" #nueva-venta-producto-sku").focus();
		});
		/*BOTON cargar venta*/
		$("#"+this.windowId+" #nueva-venta-cargar-text").bind("keydown", "return", function(e){
			e.preventDefault();
			$("#"+_this.windowId+" #nueva-venta-cargar-btn").trigger("click");
		});
		/*DOCUMENT Buscar producto (F2)*/
		$(document).bind("keydown", "f2", function(e){
			if($("#"+_this.windowId).is(":visible")){
				e.preventDefault();
				$("#"+_this.windowId+" #ventas-buscar-producto-btn").trigger("click");
			}
		});
		/*TEXTBOX Buscar producto (F2)*/
		$("#"+this.windowId+" .form-control").bind("keydown", "f2", function(e){
			if($("#"+_this.windowId).is(":visible")){
				e.preventDefault();
				$("#"+_this.windowId+" #ventas-buscar-producto-btn").trigger("click");
			}
		});
		$("#"+this.windowId+" #hotkey-buscar-producto-btn").on("click", function(e){
			e.preventDefault();
			if($("#"+_this.windowId).is(":visible")){
				e.preventDefault();
				$("#"+_this.windowId+" #ventas-buscar-producto-btn").trigger("click");
			}
		});
		/*TEXTBOX cantidad (ENTER)*/
		$("#"+this.windowId+" #nueva-venta-producto-cant").bind("keydown", "return", function(e){
			e.preventDefault();
			if($.trim($(this).val())!="")
				$("#"+_this.windowId+" #nueva-venta-producto-costo").focus();
		});
		/*TEXTBOX precio  (ABAJO)*/
		$("#"+this.windowId+" #nueva-venta-producto-costo").bind("keydown","down",function(e){
			e.preventDefault();
			$("#"+_this.windowId+" #nueva-venta-precio-previo-btn").trigger("click");
		});
		/*TEXTBOX precio  (ARRIBA)*/
		$("#"+this.windowId+" #nueva-venta-producto-costo").bind("keydown","up",function(e){
			e.preventDefault();
			$("#"+_this.windowId+" #nueva-venta-precio-siguente-btn").trigger("click");
		});
		/*TEXTBOX precio (ENTER)*/
		$("#"+this.windowId+" #nueva-venta-producto-costo").bind("keydown", "return", function(e){
			e.preventDefault();
			if($.trim($(this).val())!=""){
				if(!$("#"+_this.windowId+" #nueva-venta-producto-total").is("[readonly]")){
					$("#"+_this.windowId+" #nueva-venta-producto-total").focus();
				}else{
					if(!$("#"+_this.windowId+" #nueva-venta-producto-descuento").is("[readonly]")){
						$("#"+_this.windowId+" #nueva-venta-producto-descuento").focus();
					}else{
						$("#"+_this.windowId+" #nueva-venta-producto-agregar").trigger("click");
					}
				}
			}
		});
		$("#"+this.windowId+" #nueva-venta-producto-descuento").bind("keydown", "return", function(e){
			e.preventDefault();
			if($.trim($(this).val())!=""){
				if(!$("#"+_this.windowId+" #nueva-venta-producto-total").is("[readonly]")){
					$("#"+_this.windowId+" #nueva-venta-producto-total").focus();
				}else{
					$("#"+_this.windowId+" #nueva-venta-producto-agregar").trigger("click");
				}
			}				
		});
		$("#"+this.windowId+" #nueva-venta-producto-total").bind("keydown", "return", function(e){
			e.preventDefault();
			if($.trim($(this).val())!=""){
				$("#"+_this.windowId+" #nueva-venta-producto-agregar").trigger("click");
			}				
		});
		/*DOCUMENT guardar venta (F10)*/
		$(document).bind('keydown', 'f10', function(e){
			if($("#"+_this.windowId).is(":visible")){
				e.preventDefault();
				$("#"+_this.windowId+" #guardar-venta-btn").trigger('click');
			}
		});
		/*TEXTBOXguardar venta (F10)*/
		$("#"+this.windowId+" .form-control").bind('keydown', 'f10', function(e){
			if($("#"+_this.windowId).is(":visible")){
				e.preventDefault();
				$("#"+_this.windowId+" #guardar-venta-btn").trigger('click');
			}
		});
		$("#"+this.windowId+" #hotkey-guardar-venta-btn").on("click", function(e){
			e.preventDefault();
			if($("#"+_this.windowId).is(":visible")){
				e.preventDefault();
				$("#"+_this.windowId+" #guardar-venta-btn").trigger("click");
			}
		});
		/*TEXTBOX dui (ENTER)*/
		$("#"+this.windowId+" #nueva-venta-cliente-dui").bind("keydown", "return", function(e){
			e.preventDefault();
			$("#"+_this.windowId+" #nueva-venta-cliente-nit").focus();
		});
		/*TEXTBOX nit (ENTER)*/
		$("#"+this.windowId+" #nueva-venta-cliente-nit").bind("keydown", "return", function(e){
			e.preventDefault();
			$("#"+_this.windowId+" #nueva-venta-cliente-nrc").focus();
		});
		/*TEXTBOX nrc (ENTER)*/
		$("#"+this.windowId+" #nueva-venta-cliente-nrc").bind("keydown", "return", function(e){
			e.preventDefault();
			$("#"+_this.windowId+" #nueva-venta-doc-guardar-btn").trigger("click");
		});
		/*TEXTBOX Forma de pago (ENTER)*/
		$("#"+this.windowId+" #nueva-venta-forma-pago-efectivo,#"+this.windowId+" #nueva-venta-forma-pago-efectivo-mixto,#nueva-venta-forma-pago-pos-mixto").bind("keydown", "return", function(e){
			e.preventDefault();
			/* if($("#"+_this.windowId+" #nueva-venta-impresion").is(":visible"))
				$("#"+_this.windowId+" #nueva-venta-impresion").focus();
			else
				$("#"+_this.windowId+" #nueva-venta-fpago-guardar-btn").trigger("click"); */
			$("#"+_this.windowId+" #nueva-venta-fpago-guardar-btn").trigger("click");
		});
		/*SELECT Impresion (ENTER)*/
		$("#"+this.windowId+" #nueva-venta-impresion").bind("keydown", "return", function(e){
			e.preventDefault();
			$("#"+_this.windowId+" #nueva-venta-fpago-guardar-btn").trigger("click");
		});
	},
	/*------- FUNCIONES -------*/
	/*Agregar o quitar un cliente*/
	this.setCliente=function($sender){
		var _this=this;
		if($sender.attr('data-function')=='set'){
			Custombox.open({
				target:_this.baseUrl+"clientes/listamini?field=nueva-venta-cliente-text&idfield=nueva-venta-cliente&duifield=nueva-venta-cliente-dui&nitfield=nueva-venta-cliente-nit&nrcfield=nueva-venta-cliente-nrc&sender="+$sender.attr('id'),
				effect: 'fadein',
				close:function(){
					_this.updatePriceProfile(true);
					$("#"+_this.windowId+" #nueva-venta-condicion").focus();
				}
			});
		}else{
			$("#"+this.windowId+" #nueva-venta-cliente-text").val('');
			$("#"+this.windowId+" #nueva-venta-cliente").val('');
			$("#"+this.windowId+" #nueva-venta-cliente-dui").val('');
			$("#"+this.windowId+" #nueva-venta-cliente-nit").val('');
			$("#"+this.windowId+" #nueva-venta-cliente-nrc").val('');
			$("#"+this.windowId+" #nueva-venta-cliente-text").removeAttr('readonly');
			$("#"+this.windowId+" #nueva-venta-cliente-buscar-btn").removeClass('btn-default');
			$("#"+this.windowId+" #nueva-venta-cliente-buscar-btn").addClass('btn-info');
			$("#"+this.windowId+" #nueva-venta-cliente-buscar-btn").find('i').removeClass('fa-times');
			$("#"+this.windowId+" #nueva-venta-cliente-buscar-btn").find('i').addClass('fa-search');
			$("#"+this.windowId+" #nueva-venta-cliente-buscar-btn").attr('data-function','set');
			$("#"+this.windowId+" #nueva-venta-cliente-text").attr('data-type','0');
			$("#"+this.windowId+" #nueva-venta-cliente-text").attr('data-credito','0');
			$("#"+this.windowId+" #credito-venta").val('');
			$("#"+this.windowId+" #ncredito-fecha-limite").val('');
			$("#"+this.windowId+" #nueva-venta-cliente-text").focus();
			_this.updatePriceProfile(true);			
		}
	},
	/*Actualizar perfil de precios*/
	this.updatePriceProfile=function(updateProductTable){
		var clientType=parseInt($("#"+this.windowId+" #nueva-venta-cliente-text").attr("data-type"));
		var docType=parseInt($("#"+this.windowId+" #nueva-venta-documento").val());
		strUpdate="";
		if(clientType==4){/*Exento*/
			if(docType==2){/*ccf*/
				this.Transtools.SetTotalsProfile("grabadas,iva,subtotal,nosujetas,exentas,descuentos,total","subtotal|+|nosujetas|+|exentas|-|descuentos",true);
				$("#"+this.windowId+" #nueva-venta-perfil-precios").val("1");
				if(updateProductTable){
					strUpdate='.table-tipoventa@replacewtrans:3@.table-tipoventa:data-value|=|0';
				}
			}
			else{/*Desconocido, ninguno, factura, ticket, nota remision, nota envio, etc.*/
				this.Transtools.SetTotalsProfile("grabadas,nosujetas,exentas,descuentos,total","grabadas|+|nosujetas|+|exentas|-|descuentos",true);
				$("#"+this.windowId+" #nueva-venta-perfil-precios").val("0");
				if(updateProductTable){
					strUpdate='.table-precio@operation:.table-precio|/|1.13@.table-tipoventa:data-value|=|0,.table-tipoventa@replacewtrans:3@.table-tipoventa:data-value|=|0,.table-total@operation:.table-precio|*|.table-cant';
				}
			}			
		}
		else if(clientType==3){/*Gran contribuyente*/
			if(docType==2){/*ccf*/
				this.Transtools.SetTotalsProfile("grabadas,iva,subtotal,retencion,nosujetas,exentas,descuentos,total","subtotal|-|retencion|+|nosujetas|+|exentas|-|descuentos",true);
				if(updateProductTable && $("#"+this.windowId+" #nueva-venta-perfil-precios").val()=="0"){
					strUpdate='.table-precio@operation:.table-precio|/|1.13@.table-tipoventa:data-value|=|0,.table-total@operation:.table-precio|*|.table-cant';
					$("#"+this.windowId+" #nueva-venta-perfil-precios").val("1");
				}
			}
			else{/*Desconocido, ninguno, factura, ticket, nota remision, nota envio, etc.*/
				this.Transtools.SetTotalsProfile("grabadas,retencionFac,nosujetas,exentas,descuentos,total","grabadas|-|retencionFac|+|nosujetas|+|exentas|-|descuentos",true);
				if(updateProductTable && $("#"+this.windowId+" #nueva-venta-perfil-precios").val()=="1"){
					strUpdate='.table-precio@operation:.table-precio|*|0.13|+|.table-precio@.table-tipoventa:data-value|=|0,.table-total@operation:.table-precio|*|.table-cant';
					$("#"+this.windowId+" #nueva-venta-perfil-precios").val("0");
				}
			}
		}
		else{/*No, otros y mediano contribuyente*/
			if(docType==2){/*ccf*/
				this.Transtools.SetTotalsProfile("grabadas,iva,subtotal,nosujetas,exentas,descuentos,total","subtotal|+|nosujetas|+|exentas|-|descuentos",true);
				if(updateProductTable){
					if($("#"+this.windowId+" #nueva-venta-perfil-precios").val()=="0"){
						strUpdate='.table-precio@operation:.table-precio|/|1.13@.table-tipoventa:data-value|=|0,.table-total@operation:.table-precio|*|.table-cant';
						$("#"+this.windowId+" #nueva-venta-perfil-precios").val("1");
					}else{
						strUpdate='.table-tipoventa@replacewtrans:0@.table-tipoventa:data-value|=|3';
					}
				}
			}
			else{/*Desconocido, ninguno, factura, ticket, nota remision, nota envio, etc.*/
				this.Transtools.SetTotalsProfile("grabadas,nosujetas,exentas,descuentos,total","grabadas|+|nosujetas|+|exentas|-|descuentos",true);
				if(updateProductTable){
					if($("#"+this.windowId+" #nueva-venta-perfil-precios").val()=="1"){
						strUpdate='.table-precio@operation:.table-precio|*|0.13|+|.table-precio@.table-tipoventa:data-value|=|0,.table-total@operation:.table-precio|*|.table-cant';
						$("#"+this.windowId+" #nueva-venta-perfil-precios").val("0");
					}else{
						strUpdate='.table-precio@operation:.table-precio|*|0.13|+|.table-precio@.table-tipoventa:data-value|=|3,.table-tipoventa@replacewtrans:0@.table-tipoventa:data-value|=|3,.table-total@operation:.table-precio|*|.table-cant';
					}
				}
			}
		}
		
		if(updateProductTable && strUpdate!=""){
			this.Transtools.updateTable(strUpdate,true);
		}
				
	},
	/*Calcualr total de producto a agregar*/
	this.calcSingleTotal=function(cant,precio,$wrapper){
		if(cant!="" && precio!="")
			$wrapper.val((parseFloat(cant)*parseFloat(precio)).toFixed(4));
		else
			$wrapper.val(0);
	},
	this.calcDescuento=function(total,precio,$wrapper){
		if(total!="" && precio!="")
			$wrapper.val((((parseFloat(precio) - parseFloat(total)) * 100) / parseFloat(precio)).toFixed(4));
		else
			$wrapper.val(0);
	},
	/*Agregar un producto a la tabla*/
	this.addProductToTable=function(validPrecio,validCant){
		var _this=this;
		var valid=true;
		 var conf=this.config
		 /*Validar precios*/
		if(this.config.transacciones_validar_precio && this.config.transacciones_validar_precio>0){
			if(!validPrecio){
				var precio=parseFloat($("#"+this.windowId+" #nueva-venta-producto-costo").val());
				var preciomin=parseFloat($("#"+this.windowId+" #nueva-venta-producto-precio-bajo").val());
				if(precio<preciomin){
					var precioMsg="El precio ingresado es inferior al m&iacute;nimo autorizado.";
					switch(parseInt(this.config.transacciones_validar_precio)){
						/*Mostrar mensaje de abvertencia*/
						case 1:{
							valid=false;
							swal({
								title: "Precio m&iacute;nimo",
								text: precioMsg+"<br> &iquest;Desea utilizar este precio?",
								type: "warning",
								html: true,
								showCancelButton: true,
								confirmButtonColor: "#DD6B55",
								confirmButtonText: "Si, agregar producto",
								cancelButtonText: "No",
								closeOnConfirm: false,
								closeOnCancel: true
							},
							function(isConfirm){
								if (isConfirm) {
									_this.addProductToTable(true,validCant);
								}
							});
						break;}
						/*Solicitar Llave*/
						case 2:{
							valid=false;
							this.keys.getKey({
								method:'returnToFunction',
								msg:precioMsg+"<br/> Ingrese una llave de autorizaci&oacute;n",
								returnClass:_this,
								returnFunction:"addProductToTable",
								params:[validPrecio,validCant],
								indexParamReplace:0
							});
						break;}
						/*No permitir*/
						case 3:{
							valid=false;
							swal({
								title: "Precio m&iacute;nimo",
								text: precioMsg+"<br> Esta acci&oacute;n no esta permitida",
								type: "error",
								html: true,
								showCancelButton: false,
								confirmButtonColor: "#DD6B55",
								confirmButtonText: "Aceptar",
								cancelButtonText: "No",
								closeOnConfirm: true,
							},function(confirm){
								$("#"+_this.windowId+" #nueva-venta-producto-costo").focus();
							});				
						break;}
					}
				}
			}
		}
		if(valid){
			/*Validar Existencias para productos*/
			if($("#"+this.windowId+" #nueva-venta-producto-tipo").val()!="1"){
				/*Validar existencias*/
				if(this.config.transacciones_validar_existencia && this.config.transacciones_validar_existencia>0){
					if(!validCant){
						var cant=parseFloat($("#"+this.windowId+" #nueva-venta-producto-cant").val())*parseFloat($("#"+this.windowId+" #nueva-venta-unidades-representativas").val());
						var existencia= parseFloat($("#"+this.windowId+" #nueva-venta-producto-existencias").val());
						var existenciaequival=parseFloat($("#"+this.windowId+" #nueva-venta-producto-existencias").val())/parseFloat($("#"+this.windowId+" #nueva-venta-unidades-representativas").val());
						var descripcion=$("#"+this.windowId+" #nueva-venta-producto-desc").val();
						if(cant > existencia){
							var msg="Las cantidad requerida ("+$("#"+this.windowId+" #nueva-venta-producto-cant").val()+" "+descripcion+") para este producto supera las existencias. (<strong>"+existenciaequival+" "+descripcion+"</strong>).";
							switch(parseInt(this.config.transacciones_validar_existencia)){
								/*Mostrar mensaje de abvertencia*/
								case 1:{
									valid=false;
									swal({
										title: "Existencias insuficientes",
										text: msg+"<br> &iquest;Desea agregar este producto a la lista?",
										type: "warning",
										html: true,
										showCancelButton: true,
										confirmButtonColor: "#DD6B55",
										confirmButtonText: "Si, agregar producto",
										cancelButtonText: "No",
										closeOnConfirm: false,
										closeOnCancel: true
									},
									function(isConfirm){
										if (isConfirm) {
											_this.addProductToTable(validPrecio,true);
										}
									});
								break;}
								/*Solicitar Llave*/
								case 2:{
									valid=false;
									this.keys.getKey({
										method:'returnToFunction',
										msg:msg+"<br/> Ingrese una llave de autorizaci&oacute;n para continuar",
										returnClass:_this,
										returnFunction:"addProductToTable",
										params:[validPrecio,validCant],
										indexParamReplace:1
									});
								break;}
								/*No permitir*/
								case 3:{
									valid=false;
									swal({
										title: "Existencias insuficientes",
										text: msg+"<br> Esta acci&oacute;n no esta permitida",
										type: "error",
										html: true,
										showCancelButton: false,
										confirmButtonColor: "#DD6B55",
										confirmButtonText: "Aceptar",
										cancelButtonText: "No",
										closeOnConfirm: true,
									},function(confirm){
										$("#"+_this.windowId+" #nueva-venta-producto-cant").focus();
									});								
								break;}
							}
						}
					}
				}
			}
		}
		if(valid){
			var currentSel = $("#"+this.windowId+" #nueva-venta-productos-wrapper > table > tbody > tr.miracle-selected-table-item");
			currentSel.removeClass("miracle-selected-table-item");
			var desgloseIVA=false;
			if(parseInt($("#"+this.windowId+" #nueva-venta-cliente-text").attr("data-type"))===4){/*Ajuste para clientes exentos*/
				if($("#"+this.windowId+" #nueva-venta-producto-tipoventa").val()=='0'){
					$("#"+this.windowId+" #nueva-venta-producto-tipoventa").val("3");
					desgloseIVA=true;
				}
			}
			if($("#"+this.windowId+" #nueva-venta-documento").val()=='2' && $("#"+this.windowId+" #nueva-venta-producto-tipoventa").val()=='0'){
				desgloseIVA=true;
			}
			if(desgloseIVA){
				this.Transtools.addProductToTable('data:.frame-producto-id@data-id,data:.frame-producto-ref@data-ref,data:.frame-presentacion-id@data-pre,data:.frame-producto-tipo@data-tipo,data:.frame-producto-interno@data-interno,data:.frame-unidades-representativas@data-uequiv,field:.frame-producto-sku@table-sku,field:.frame-producto-desc@table-desc,field:.frame-producto-cant@table-cant,operation:.frame-producto-precio|/|1.13@table-precio,operation:|(|.frame-producto-precio|/|1.13|)||*|.frame-producto-cant@table-total,operation:|(||(|.frame-producto-precio|/|1.13|)||*|.frame-producto-cant|)||*|.frame-producto-descuento@table-descuento,translation:.frame-producto-tipoventa@table-tipoventa,command:remove@table-del');
			}else{
				this.Transtools.addProductToTable('data:.frame-producto-id@data-id,data:.frame-producto-ref@data-ref,data:.frame-presentacion-id@data-pre,data:.frame-producto-tipo@data-tipo,data:.frame-producto-interno@data-interno,data:.frame-unidades-representativas@data-uequiv,field:.frame-producto-sku@table-sku,field:.frame-producto-desc@table-desc,field:.frame-producto-cant@table-cant,field:.frame-producto-precio@table-precio,operation:.frame-producto-cant|*|.frame-producto-precio@table-total,operation:|(|.frame-producto-cant|*|.frame-producto-precio|)||*|.frame-producto-descuento|/|100@table-descuento,translation:.frame-producto-tipoventa@table-tipoventa,command:remove@table-del');
			}
			/*Scroll*/
			if($("#"+this.windowId+" #nueva-venta-productos-wrapper > table ").height()>=($("#"+this.windowId+" #nueva-venta-productos-wrapper").scrollTop()+$("#"+this.windowId+" nueva-venta-productos-wrapper").height())){
				 $("#"+this.windowId+" #nueva-venta-productos-wrapper").scrollTop($("#"+this.windowId+" #nueva-venta-productos-wrapper").scrollTop()+40);
			}
			swal.close();
		}
	},
	/*Cargar Informacion*/
	this.cargarTransaccion=function($text,$sender){
		var _this=this;
		$text.prop("disabled","disabled");
		$sender.prop("disabled","disabled");
		var queryElement=$text.val().split("-");
		var transaccion="ventatemp";
		var id=$text.val();
		if(queryElement[0] && queryElement[1]){
			id=queryElement[1]
			switch($.trim(queryElement[0])){
				case "t":case "T":transaccion="ventatemp";break;
				case "c":case "C":transaccion="cotizacion";break;
				case "v":case "V":transaccion="venta";break;
				case "p":case "P":transaccion="pedido";break;
			}
		}		
		$.get(this.baseUrl+"transacciones/cargartransaccion",{transaccion:transaccion,id:id},function(response){
			if(response){
				if(response.load_info && response.load_productos){
					_this.fillForm(response.load_info,response.load_productos,$("#"+_this.windowId+" #guardar-venta-btn"));
				}else{
					toastr.options = {
						"closeButton": true,
						"progressBar": true,
						"positionClass": "toast-top-right"
					}
					toastr["error"]("No se ha encontrado información de la transaccion especificada");
					$text.removeAttr("disabled");
					$("#"+_this.windowId+" #nueva-venta-cargar-btn").removeClass("btn-danger");
					$("#"+_this.windowId+" #nueva-venta-cargar-btn").addClass("btn-info");
					$("#"+_this.windowId+" #nueva-venta-cargar-btn").find("i").removeClass("fa-times");
					$("#"+_this.windowId+" #nueva-venta-cargar-btn").find("i").addClass("fa-check");
					$("#"+_this.windowId+" #nueva-venta-cargar-btn").attr("data-function","set");
				}
			}
			$sender.removeAttr("disabled");
		},"json");
	}
	/*Llenar Formulario de venta*/
	this.fillForm=function(info,productos,focus){
		var _this=this;
		/*Cliente*/
		if(info.cliente_nombre)
			$("#"+this.windowId+" #nueva-venta-cliente-text").val(info.cliente_nombre);
		if(info.cliente_id){
			$("#"+this.windowId+" #nueva-venta-cliente").val(info.cliente_id);
			$("#"+this.windowId+" #nueva-venta-cliente-text").attr("data-credito",info.cliente_credito);
			$("#"+this.windowId+" #nueva-venta-cliente-text").attr("data-type",info.cliente_clasificacion);
			$("#"+this.windowId+" #nueva-venta-cliente-text").prop('readonly','true');
			$("#"+this.windowId+" #nueva-venta-cliente-buscar-btn").removeClass('btn-info');
			$("#"+this.windowId+" #nueva-venta-cliente-buscar-btn").find('i').removeClass('fa-search');
			$("#"+this.windowId+" #nueva-venta-cliente-buscar-btn").addClass('btn-default');
			$("#"+this.windowId+" #nueva-venta-cliente-buscar-btn").find('i').addClass('fa-times');
			$("#"+this.windowId+" #nueva-venta-cliente-buscar-btn").attr('data-function','unset');
		}
		if(info.cliente_dui)
			$("#"+this.windowId+" #nueva-venta-cliente-dui").val(info.cliente_dui);
		if(info.cliente_nit)
			$("#"+this.windowId+" #nueva-venta-cliente-nit").val(info.cliente_nit);
		if(info.cliente_nrc)
			$("#"+this.windowId+" #nueva-venta-cliente-nrc").val(info.cliente_nrc);
		/*condicion*/
		if(info.venta_condicion)
			$("#"+this.windowId+" #nueva-venta-condicion option[value='"+info.venta_condicion+"']").prop('selected', true);
		else{
			if(this.defaultValues.venta_condicion){
				$("#"+this.windowId+" #nueva-venta-condicion option[value='"+this.defaultValues.venta_condicion+"']").prop('selected', true);
			}else{
				$("#"+this.windowId+" #nueva-venta-condicion").find("option:first").prop('selected', true);
			}
		}
		/*Documento*/
		if(info.venta_doc){
			$("#"+this.windowId+" #nueva-venta-documento option[value='"+info.venta_doc+"']").prop('selected', true);
			if(info.venta_doc==2){
				$("#"+this.windowId+" #nueva-venta-perfil-precios").val(1);
			}else{
				$("#"+this.windowId+" #nueva-venta-perfil-precios").val(0);
			}
		}else{
			if(this.defaultValues.venta_doc){
				$("#"+this.windowId+" #nueva-venta-documento option[value='"+this.defaultValues.venta_doc+"']").prop('selected', true);
				if(this.defaultValues.venta_doc==2){
					$("#"+this.windowId+" #nueva-venta-perfil-precios").val(1);
				}else{
					$("#"+this.windowId+" #nueva-venta-perfil-precios").val(0);
				}
			}else{
				$("#"+this.windowId+" #nueva-venta-documento").find("option:first").prop('selected', true);
				if($("#"+this.windowId+" #nueva-venta-documento").find("option:first").val()==2){
					$("#"+this.windowId+" #nueva-venta-perfil-precios").val(1);
				}else{
					$("#"+this.windowId+" #nueva-venta-perfil-precios").val(0);
				}
			}
		}
		/*Serie*/
		if(info.venta_seriedoc){
			if(info.venta_seriedoc=="auto"){
				if(info.venta_numdoc && info.venta_numdoc=="auto"){
					if(info.venta_doc){
						this.setAutoNumDoc(info.venta_doc,true);
					}else{
						this.setAutoNumDoc($("#"+this.windowId+" #nueva-venta-documento").val(),true);
					}
				}else
					this.setAutoNumDoc(info.venta_doc,false);
			}else{
				if(this.setAutoNumDoc($("#"+this.windowId+" #nueva-venta-documento").val(),false)); 
					$("#"+this.windowId+" #nueva-venta-documento-serie option[value='"+info.venta_seriedoc+"']").prop('selected', true);
			}
		}else{
			this.setAutoNumDoc($("#"+this.windowId+" #nueva-venta-documento").val(),false);
		}
		/*Numero de documento*/
		if(info.venta_numdoc && info.venta_numdoc!="auto"){
			$("#"+this.windowId+" #nueva-venta-documento-numero").val(info.venta_numdoc);
		}else{
			if(info.venta_seriedoc!="auto"){
				this.setNumDoc();
			}
		}
		/*Transaccion*/
		if(info.str_query){
			$("#"+this.windowId+" #nueva-venta-cargar-text").val(info.str_query);
			$("#"+this.windowId+" #nueva-venta-cargar-text").prop("disabled","disabled");
			$("#"+this.windowId+" #nueva-venta-cargar-btn").removeClass("btn-info");
			$("#"+this.windowId+" #nueva-venta-cargar-btn").addClass("btn-danger");
			$("#"+this.windowId+" #nueva-venta-cargar-btn").find("i").removeClass("fa-check");
			$("#"+this.windowId+" #nueva-venta-cargar-btn").find("i").addClass("fa-times");
			$("#"+this.windowId+" #nueva-venta-cargar-btn").attr("data-function","unset");
		}
		if(info.transaccion){
			$("#"+this.windowId+" #nueva-venta-cargar-text").attr("data-transaccion",info.transaccion);
		}
		if(info.id_transaccion){
			$("#"+this.windowId+" #nueva-venta-cargar-text").attr("data-id",info.id_transaccion);
		}
		/*Vendedor*/
		if(info.venta_vendedor)
			$("#"+this.windowId+" #nueva-venta-vendedor-id").val(info.venta_vendedor);
		/*Productos*/
		if(productos && Object.keys(productos).length>0){
			var productosHTML="";
			for(var i=0;i<Object.keys(productos).length;i++){
				var existenciasOk=1;
				if((productos[i].cant*productos[i].uequiv)>productos[i].existencia){
					existenciasOk=0;
				}
				
				productosHTML+="<tr data-id='"+productos[i].id+"' data-ref='"+productos[i].ref+"' data-pre='"+productos[i].id_pre+"' data-tipo='"+productos[i].tipo_producto+"' data-interno='"+productos[i].interno+"' data-uequiv='"+productos[i].uequiv+"' data-existencias_ok='"+existenciasOk+"'>";
				productosHTML+="<td class='table-sku' data-value='"+productos[i].sku+"'>"+productos[i].sku+"</td>";
				productosHTML+="<td class='table-desc' data-value='"+productos[i].nombre+"'>"+productos[i].nombre+"</td>";
				productosHTML+="<td class='table-cant' data-value='"+productos[i].cant+"' title='Existencias: "+productos[i].existencia+"'>"+productos[i].cant;
				if(!existenciasOk){
					productosHTML+=" <i class='text-warning fa fa-exclamation-triangle'></i>";
				}
				productosHTML+="</td>";
				productosHTML+="<td class='table-precio' data-value='"+productos[i].precio+"'>"+productos[i].precio+"</td>";
				productosHTML+="<td class='table-total' data-value='"+(productos[i].cant*productos[i].precio).toFixed(3)+"'>"+(productos[i].cant*productos[i].precio).toFixed(3)+"</td>";
				productosHTML+="<td class='table-descuento' data-value='"+productos[i].descuento+"'>"+productos[i].descuento+"</td>";
				productosHTML+="<td class='table-tipoventa' data-value='"+productos[i].tipo+"'>"+(productos[i].tipo==0?"G":(productos[i].tipo==1)?"E":(productos[i].tipo==2)?"NS":(productos[i].tipo==3)?"E":"")+"</td>";
				productosHTML+="<td class='table-del'><button type='button' class='btn btn-danger btn-xs btn-rounded'><i class='fa fa-times'></i></button></td></tr>";
			}
			$("#"+this.windowId+" #nueva-venta-productos-wrapper > table > tbody").html(productosHTML);
			this.updatePriceProfile(false);
			this.Transtools.calcTotals();
			this.revisarExistencias();
		}
		focus.focus();
	},
	/*Revisar existencias*/
	this.revisarExistencias=function(){
		if(typeof this.config.transacciones_validar_existencia_trans !== 'undefined' && this.config.transacciones_validar_existencia_trans>0){
			var _this=this;
			var productos=$("#"+this.windowId+" #nueva-venta-productos-wrapper > table > tbody > tr");
			var productosExistenciasInsuficiente=0;
			if($("#"+_this.windowId+" #nueva-venta-existencias-ok").val()!="2"){/*Si la existencias ya han sido autorizadas*/
				$("#"+_this.windowId+" #nueva-venta-existencias-ok").val("1");
				$("#"+_this.windowId+" #nueva-venta-no-existencias-msg").hide();
				$("#"+_this.windowId+" #nueva-venta-no-existencias-msg #nueva-venta-no-existencias-msg-option").html("");
			}
			if(productos.length){
				productos.each(function(i,tr){
					if($(tr).attr("data-existencias_ok")==0){
						productosExistenciasInsuficiente+=1;
						switch(parseInt(_this.config.transacciones_validar_existencia_trans)){
							case 2:{
								if($("#"+_this.windowId+" #nueva-venta-existencias-ok").val()!="2"){
									$("#"+_this.windowId+" #nueva-venta-no-existencias-msg #nueva-venta-no-existencias-msg-option").html("<button id='nueva-venta-no-existencia-autorizar-btn' class='btn btn-warning btn-sm'>Autorizar existencias</button>");
									$("#"+_this.windowId+" #nueva-venta-existencias-ok").val("0");
								}
							}break;
							case 3:{
								$("#"+_this.windowId+" #nueva-venta-no-existencias-msg #nueva-venta-no-existencias-msg-option").html("<h4>No es posible guardar esta venta.</h4>");
								$("#"+_this.windowId+" #nueva-venta-existencias-ok").val("0");
							}break;
						}
						$("#"+_this.windowId+" #nueva-venta-no-existencias-msg").show();
						return false;
					}
				});
			}
			if(!productosExistenciasInsuficiente){
				$("#"+_this.windowId+" #nueva-venta-existencias-ok").val("1");
				$("#"+_this.windowId+" #nueva-venta-no-existencias-msg").hide();
			}
		}
	},
	/*Autorizar uso de existencias insuficientes*/
	this.autorizarExistencias=function(valid){
		if(!valid){
			var _this=this;
			this.keys.getKey({
				method:'returnToFunction',
				msg:"Existencias insuficientes en venta. <br/> Ingrese una llave de autorizaci&oacute;n",
				returnClass:_this,
				returnFunction:"autorizarExistencias",
				params:[valid],
				indexParamReplace:0
			});
		}else{
			swal.close();
			$("#"+this.windowId+" #nueva-venta-no-existencias-msg #nueva-venta-no-existencias-msg-option").html("<h4>&iexcl;Existencias autorizadas!<a id='nueva-venta-no-existencias-revertir-link' class='alert-link' href='javascript:void(0)'>[Revertir]</a></h4>");
			$("#"+this.windowId+" #nueva-venta-existencias-ok").val("2");
		}
	}
	/*Autocompletar serie y numero de documento*/
	this.setAutoNumDoc=function(doc,useFirst){
		var _this=this;
		$("#nueva-venta-documento-serie option").remove();
		$("#nueva-venta-documento-serie").val("");
		$("#nueva-venta-documento-numero").val('');
			jQuery.ajaxSetup({async:false});
		$.get(this.baseUrl+"administracion/resolucionesxdoc",{doc:doc,caja:this.caja,activas:true},function(series){
			if(series){
				$.each(series,function(i,serie){
					$("#"+_this.windowId+" #nueva-venta-documento-serie").append($('<option>',{ 
						value:serie.serie,
						'data-id':serie.id,
						'data-act':serie.actual,
						text:serie.serie 
					}));
				});
				$("#nueva-venta-documento-serie option:first").attr('selected','selected');
				if(useFirst){
					if(doc==3){
					//if(doc==1){
						$("#"+_this.windowId+" #nueva-venta-documento-numero").val("auto");
						$("#"+_this.windowId+" #nueva-venta-documento-numero").prop("readonly","true");
					}else{
						$("#nueva-venta-documento-numero").val($("#nueva-venta-documento-serie option:selected").attr("data-act"));
						$("#"+_this.windowId+" #nueva-venta-documento-numero").removeAttr("readonly");
					}
				}
			}
		},'json');
		jQuery.ajaxSetup({async:true});
		return true;
	},
	/*Establecer numero de documento*/
	this.setNumDoc=function(){
		if($("#"+this.windowId+" #nueva-venta-documento").val()==3){
			$("#"+this.windowId+" #nueva-venta-documento-numero").val("auto");
			$("#"+this.windowId+" #nueva-venta-documento-numero").prop("readonly","true");
		}else{
			$("#"+this.windowId+" #nueva-venta-documento-numero").val($("#nueva-venta-documento-serie option:selected").attr("data-act"));
			$("#"+this.windowId+" #nueva-venta-documento-numero").removeAttr("readonly");
		}
	}
	/*Reiniciar el formulario*/
	this.resetForm=function(){
		/*Perfil de precios*/
		$("#"+this.windowId+" #nueva-venta-perfil-precios").val(0);
		/*Cliente*/
		$("#"+this.windowId+" #nueva-venta-cliente").val("");
		$("#"+this.windowId+" #nueva-venta-cliente-text").val("");
		$("#"+this.windowId+" #nueva-venta-cliente-text").attr("data-credito","0");
		$("#"+this.windowId+" #nueva-venta-cliente-text").attr("data-type","0");
		/*Unset cliente*/
		$("#"+this.windowId+" #nueva-venta-cliente-text").removeAttr('readonly');
		$("#"+this.windowId+" #nueva-venta-cliente-buscar-btn").removeClass('btn-default');
		$("#"+this.windowId+" #nueva-venta-cliente-buscar-btn").addClass('btn-info');
		$("#"+this.windowId+" #nueva-venta-cliente-buscar-btn").find('i').removeClass('fa-times');
		$("#"+this.windowId+" #nueva-venta-cliente-buscar-btn").find('i').addClass('fa-search');
		$("#"+this.windowId+" #nueva-venta-cliente-buscar-btn").attr('data-function','set');
		/*Condicion*/
		$("#"+this.windowId+" #nueva-venta-condicion option[value='0']").prop('selected', true);
		/*Documento*/
		$("#"+this.windowId+" #nueva-venta-documento option:first").prop('selected', true);
		/*Serie*/
		$("#"+this.windowId+" #nueva-venta-documento-serie option").remove();
		$("#"+this.windowId+" #nueva-venta-documento-serie").val("");
		/*Numero de documento*/
		$("#"+this.windowId+" #nueva-venta-documento-numero").val("");
		$("#"+this.windowId+" #nueva-venta-documento-numero").removeAttr("readonly");
		/*Cargar venta*/
		$("#"+this.windowId+" #nueva-venta-cargar-text").val("");
		$("#"+this.windowId+" #nueva-venta-cargar-text").attr("data-transaccion","");
		$("#"+this.windowId+" #nueva-venta-cargar-text").attr("data-id","");
		$("#"+this.windowId+" #nueva-venta-cargar-text").removeAttr("disabled");
		$("#"+this.windowId+" #nueva-venta-cargar-btn").removeClass("btn-danger");
		$("#"+this.windowId+" #nueva-venta-cargar-btn").addClass("btn-info");
		$("#"+this.windowId+" #nueva-venta-cargar-btn").find("i").removeClass("fa-times");
		$("#"+this.windowId+" #nueva-venta-cargar-btn").find("i").addClass("fa-check");
		$("#"+this.windowId+" #nueva-venta-cargar-btn").attr("data-function","set");
		/*Existencias OK*/
		$("#"+this.windowId+" #nueva-venta-existencias-ok").val("1");
		$("#"+this.windowId+" #nueva-venta-no-existencias-msg").hide();
		$("#"+this.windowId+" #nueva-venta-no-existencias-msg #nueva-venta-no-existencias-msg-option").html("");
		/*Agregar producto*/
		$("#"+this.windowId+" #nueva-venta-producto-info").find(".frame-control").each(function(){
			$(this).val('');
		});
		$("#"+this.windowId+" #nueva-venta-producto-info").find('.frame-producto-price-indicator').text('');
		/*tabla de productos*/
		$("#"+this.windowId+" #nueva-venta-productos-wrapper > table > tbody").empty();		
		/*contador de producto*/
		$("#"+this.windowId+" .transacction-item-counter > b").text("0");
		/*totales*/
		this.updatePriceProfile(false);
		/*--- Ocultos ---*/
		/*Credito ocultos*/
		$("#"+this.windowId+" #credito-venta").val('');
		$("#"+this.windowId+" #ncredito-fecha-limite").val('');
		/*Forma pago ocultos*/		
		$("#"+this.windowId+" #forma-pago").val("");
		$("#"+this.windowId+" #efectivo-venta").val("");
		$("#"+this.windowId+" #pos-venta").val("");
		$("#"+this.windowId+" #cambio-venta").val("");
		/*Vendedor*/
		$("#"+this.windowId+" #nueva-venta-vendedor-id").val("");
		/*--- Modales ---*/
		/*Modal Documentos del cliente*/
		$("#"+this.windowId+" #nueva-venta-cliente-dui").val("");
		$("#"+this.windowId+" #nueva-venta-cliente-nit").val("");
		$("#"+this.windowId+" #nueva-venta-cliente-nrc").val("");
		/*Modal Forma de pago*/
		$("#"+this.windowId+" #nueva-venta-forma-pago-select option:first").attr('selected','selected');
		$("#"+this.windowId+" #nueva-venta-forma-pago-efectivo").val();
		$("#"+this.windowId+" #nueva-venta-forma-pago-efectivo-mixto").val();
		$("#"+this.windowId+" #nueva-venta-forma-pago-pos-mixto").val();
		$("#"+this.windowId+" #nueva-venta-forma-pago-cambio").val();
		$("#"+this.windowId+" #nueva-venta-forma-pago-cambio-mixto").val();
		$("#"+this.windowId+" #nueva-venta-impresion option[value='0']").prop('selected', true);
		/*Modal confirmar*/
		$("#"+this.windowId+" #nueva-venta-procesar-status-icon").html("<i style='color:#23C6C8;' class='fa fa-question-circle fa-5x'></i>");
		$("#"+this.windowId+" #nueva-venta-procesar-status-text").text('&iquest;Desea guardar esta venta?');
		$("#"+this.windowId+" #nueva-venta-confirm-total").text("");
		$("#"+this.windowId+" #nueva-venta-confirm-efectivo").text("");
		$("#"+this.windowId+" #nueva-venta-confirm-cambio").text("");
		/*Botones*/
		$("#"+this.windowId+" #guardar-venta-btn").removeAttr("disabled");
		$("#"+this.windowId+" #nueva-venta-doc-cancel-btn").removeAttr("disabled");
		$("#"+this.windowId+" #nueva-venta-doc-guardar-btn").removeAttr("disabled");
		$("#"+this.windowId+" #nueva-venta-credito-cancel-btn").removeAttr("disabled");
		$("#"+this.windowId+" #nueva-venta-credito-guardar-btn").removeAttr("disabled");
		$("#"+this.windowId+" #nueva-venta-fpago-cancel-btn").removeAttr("disabled");
		$("#"+this.windowId+" #nueva-venta-fpago-guardar-btn").removeAttr("disabled");
		$("#"+this.windowId+" #nueva-venta-cancelar-guardar-btn").removeAttr("disabled");
		$("#"+this.windowId+" #nueva-venta-confirmar-guardar-btn").removeAttr("disabled");
		$("#"+this.windowId+" #nueva-venta-confirmar-salir-btn").removeAttr("disabled");
		$("#"+this.windowId+" #nueva-venta-reset-btn").removeAttr("disabled");
		$("#"+this.windowId+" #nueva-venta-cancelar-guardar-btn").show();
		$("#"+this.windowId+" #nueva-venta-confirmar-guardar-btn").show();
		$("#"+this.windowId+" #nueva-venta-confirmar-salir-btn").hide();
		$("#"+this.windowId+" #nueva-venta-reset-btn").hide();
		/**/
		$("#"+this.windowId+" #nueva-venta-producto-descuento").val("0");
		$("#"+this.windowId+" #nueva-venta-vendedor-id").val("");
		this.setDefaults(this.defaultValues,true,this.defaultFocus);
	}
	this.goTop=function(){
		if($("#"+this.windowId).is(":visible")){
			var trows=$("#"+this.windowId+" #nueva-venta-productos-wrapper > table > tbody tr");
			if(trows.size()>1){
				var currentSel = $("#"+this.windowId+" #nueva-venta-productos-wrapper > table > tbody > tr.miracle-selected-table-item");
				var prevSel=currentSel.prev();
				if(prevSel.length > 0){
					currentSel.removeClass("miracle-selected-table-item");
					prevSel.addClass("miracle-selected-table-item");
					/*AUTO SCROLL*/								
					 if(((prevSel.index()+1)*prevSel.height()) <= $("#"+this.windowId+" #nueva-venta-productos-wrapper").scrollTop()){
						 $("#"+this.windowId+" #nueva-venta-productos-wrapper").scrollTop( $("#"+this.windowId+" #nueva-venta-productos-wrapper").scrollTop()-prevSel.height());
					 }
				}
			}
		}
	},
	this.goBottom=function(){
		if($("#"+this.windowId).is(":visible")){
			var trows=$("#"+this.windowId+" #nueva-venta-productos-wrapper > table > tbody tr");
			if(trows.size()>1){
				var currentSel = $("#"+this.windowId+" #nueva-venta-productos-wrapper > table > tbody > tr.miracle-selected-table-item");
				var nextSel=currentSel.next();
				if(nextSel.length > 0){
					currentSel.removeClass("miracle-selected-table-item");
					nextSel.addClass("miracle-selected-table-item");
					/*AUTO SCROLL*/								
					 if((((nextSel.index()+1)*nextSel.height())+nextSel.height()) >= ($("#"+this.windowId+" #nueva-venta-productos-wrapper").scrollTop()+$("#"+this.windowId+" #nueva-venta-productos-wrapper").height())){
						 $("#"+this.windowId+" #nueva-venta-productos-wrapper").scrollTop( $("#"+this.windowId+" #nueva-venta-productos-wrapper").scrollTop()+nextSel.height());
					 }
				}
			}
		}
	}
}